@extends('userlayout')

@section('content')
<div class="content-w">
                <div class="content-i">
                    <div class="content-box">
                        <div class="element-wrapper compact pt-4">
                            <div class="element-actions"><a class="btn btn-primary btn-sm" href="{{route('user.profile')}}"><i
                                        class="os-icon os-icon-user"></i><span>My Account</span></a><a
                                    class="btn btn-success btn-sm" href="{{route('user.ownbank')}}"><i
                                        class="os-icon os-icon-grid-10"></i><span>Make Payment</span></a></div>
                            <h6 class="element-header">Welcome {{$user->name}}</h6>
                            <div class="element-box-tp">
                                <div class="row">
                                    <div class="col-lg-12 col-xxl-6">
                                        <div class="element-balances">
                                            <div class="balance hidden-mobile">
                                                <div class="balance-title">Account Number</div>
                                                <div class="balance-value"><span> {{$user->acct_no}}</span><span
                                                        class="trending trending-down-basic"></span></div>
                                                <div class="balance-link"><a class="btn btn-link btn-underlined"
                                                        href="{{route('user.profile')}}"><span>Account Settings</span><i
                                                            class="os-icon os-icon-arrow-right4"></i></a></div>
                                            </div>
                                            <div class="balance">
                                                <div class="balance-title">Savings Account</div>
                                                <div class="balance-value">{{$currency->symbol.number_format($user->balance)}}</div>
                                                <div class="balance-link"><a class="btn btn-link btn-underlined"
                                                        href="{{route('user.statement')}}"><span>Account Statement</span><i
                                                            class="os-icon os-icon-arrow-right4"></i></a></div>
                                            </div>
                                            <div class="balance">
                                                <div class="balance-title">Checking Account</div>
                                                <div class="balance-value success">{{$currency->symbol.number_format($user->balance)}}</div>
                                                <div class="balance-link"><a
                                                        class="btn btn-link btn-underlined btn-gold" href="{{route('user.ownbank')}}"><span>Make
                                                            Payment</span><i class="os-icon os-icon-arrow-right4"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                        </div>
                        <div class="element-wrapper">
                            <h6 class="element-header">Recent Transactions</h6>
                            <div class="element-box-tp">
                                <div class="table-responsive">
                                    <table class="table table-padded">
                                        <thead>
                                            <tr>
                                                <th>Status</th>
                                                <th>Date</th>
                                                <th>Description</th>
                                                <th class="text-center">Reference</th>
                                                <th class="text-right">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($alert as $hh)               
                                            <tr>
                                            @if($hh->status==1)
                                            <td class="nowrap"><span class="status-pill smaller green"></span><span>Complete</span> </td>
                                                @elseif($hh->status==0)
                                                <td class="nowrap"><span class="status-pill smaller yellow"></span><span>Pending</span> </td>
                                              @endif

                                                <td><span>{{date("Y/m/d h:i:A", strtotime($hh->created_at))}}</span></td>
                                                <td class="cell-with-media"><img alt="" src="img/company1.png"
                                                        style="height: 25px;"><span>{{$hh->details}}</span></td>
                                                <td class="text-center"><a class="badge badge-pill badge-primary"
                                                        href="#">#{{$hh->reference}}</a></td>
                                                        @if($hh->type==1)
                                                        <td class="text-right bolder nowrap"><span class="text-danger">- {{number_format($hh->amount). $currency->name}}</span></td>
                                                        @elseif($hh->type==2)
                                                        <td class="text-right bolder nowrap"><span class="text-success">+ {{number_format($hh->amount). $currency->name}}</span></td> 
                                                         @endif


                                            </tr>

                                            @endforeach 
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

    @stop