@extends('userlayout')

@section('content')
<div class="content-box">
    <div class="element-wrapper">
        <h6 class="element-header">Support Tickets</h6>
        <div class="">
              <h3 class="">Customer support</h3>
              <a data-toggle="modal" data-target="#modal-formx" href="" class="btn btn-primary"><i class="fa fa-arrow-right"></i> Create request</a>
            </div>
            
            <div class="element-box-tp">
            <div class="col-lg-12">
            <div class="row">
              <div class="col-md-12">
                <div class="modal fade" id="modal-formx" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                  <div class="modal-dialog modal- modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                      <div class="modal-body p-0">
                        <div class="card bg-white border-0 mb-0">
                          <div class="card-body px-lg-5 py-lg-5">
                            <form action="{{route('submit-ticket')}}" method="post">
                              @csrf
                              <div class="form-group row">
                                <label class="col-form-label col-lg-2">Subject</label>
                                <div class="col-lg-10">
                                  <div class="input-group input-group-merge">
                                    <input type="text" name="subject" maxlength="10" class="form-control" required="">
                                  </div>
                                </div>
                              </div> 
                              <div class="form-group row">
                                <label class="col-form-label col-lg-2">Priority</label>
                                <div class="col-lg-10">
                                <select class="form-control select" name="category" data-dropdown-css-class="bg-slate-800" data-fouc required>
                                  <option  value="Low">Low</option>
                                  <option  value="Medium">Medium</option> 
                                  <option  value="High">High</option>  
                                </select>
                              </div>
                              </div> 
                              <div class="form-group row">
                                <label class="col-form-label col-lg-2">Details</label>
                                <div class="col-lg-10">
                                  <textarea name="details" class="form-control" rows="4" required></textarea>
                                </div>
                              </div>                
                              <div class="text-right">
                                <button type="submit" class="btn btn-primary">Submit</button>
                              </div>
                            </form>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div> 
              </div>
            </div>

            <div class="row">
                <div class="table-responsive">
                    <table class="table table-padded">
                        <thead>
                            <tr>
                                <th>Ticket ID</th>
                                <th>Subject</th>
                                <th>Priority</th>
                                <th>Created</th>
                                <th>Updated</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($ticket as $k=>$val)
                            <tr>
                                <td>{{$val->ticket_id}}</td>
                                <td>{{$val->subject}}</td>
                                <td>{{$val->priority}}</td>
                                <td>{{date("Y/m/d h:i:A", strtotime($val->created_at))}}</td>
                                <td>{{date("Y/m/d h:i:A", strtotime($val->updated_at))}}</td>
                                <td>
                                @if($val->status==0)
                                      <span class="badge badge-info">Open</span>
                                  @elseif($val->status==1)
                                      <span class="badge badge-danger">Closed</span>                                        
                                  @elseif($val->status==2)
                                      <span class="badge badge-success">Resolved</span> 
                                  @endif
                                </td>
                                <td>
                                    <a href="{{url('/')}}/user/reply-ticket/{{$val->id}}" class="btn btn-sm btn-neutral">Reply</a>
                                    <a href="{{url('/')}}/user/ticket/delete/{{$val->id}}" class="btn btn-sm btn-danger">Delete</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>  
                  


                </div>
            </div>
            </div>
        </div>
    </div>
</div>
@stop
