<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Trunking\V1\Trunk;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

class OriginationUrlContext extends InstanceContext {
    /**
     * Initialize the OriginationUrlContext
     *
     * @param Version $version Version that contains the resource
     * @param string $trunkSid The SID of the Trunk from which to fetch the
     *                         OriginationUrl
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, $trunkSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['trunkSid' => $trunkSid, 'sid' => $sid, ];

        $this->uri = '/Trunks/' . \rawurlencode($trunkSid) . '/OriginationUrls/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch a OriginationUrlInstance
     *
     * @return OriginationUrlInstance Fetched OriginationUrlInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): OriginationUrlInstance {
        $params = Values::of([]);

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new OriginationUrlInstance(
            $this->version,
            $payload,
            $this->solution['trunkSid'],
            $this->solution['sid']
        );
    }

    /**
     * Deletes the OriginationUrlInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('delete', $this->uri);
    }

    /**
     * Update the OriginationUrlInstance
     *
     * @param array|Options $options Optional Arguments
     * @return OriginationUrlInstance Updated OriginationUrlInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): OriginationUrlInstance {
        $options = new Values($options);

        $data = Values::of([
            'Weight' => $options['weight'],
            'Priority' => $options['priority'],
            'Enabled' => Serialize::booleanToString($options['enabled']),
            'FriendlyName' => $options['friendlyName'],
            'SipUrl' => $options['sipUrl'],
        ]);

        $payload = $this->version->update(
            'POST',
            $this->uri,
            [],
            $data
        );

        return new OriginationUrlInstance(
            $this->version,
            $payload,
            $this->solution['trunkSid'],
            $this->solution['sid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Trunking.V1.OriginationUrlContext ' . \implode(' ', $context) . ']';
    }
}