/*-------------------------------------
[  Table of contents  ]
---------------------------------------
  01. Avoid `console` errors in browsers that lack a console.
  02. Scrollup jquery   
  03. WOW / scrolling animation 
  04. Isotope PACKAGED v2.2.0
  05. MeanMenu jquery Menu Plugin / Mobile Menu
------------------------------------
[ End table content ]
-----------------------------------*/

/*-------------------------------------------------------------
  01. Avoid `console` errors in browsers that lack a console.
---------------------------------------------------------------*/


(function() {
    var method;
    var noop = function () {};
    var methods = [
        'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
        'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
        'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
        'timeline', 'timelineEnd', 'timeStamp', 'trace', 'warn'
    ];
    var length = methods.length;
    var console = (window.console = window.console || {});

    while (length--) {
        method = methods[length];

        // Only stub undefined methods.
        if (!console[method]) {
            console[method] = noop;
        }
    }
}());

// Place any jQuery/helper plugins in here.

/*-------------------------------------------------------------
  02. Scrollup jquery 
---------------------------------------------------------------*/

/*!
 * scrollup v2.4.1
 * Url: http://markgoodyear.com/labs/scrollup/
 * Copyright (c) Mark Goodyear — @markgdyr — http://markgoodyear.com
 * License: MIT
 */
!function(l,o,e){"use strict";l.fn.scrollUp=function(o){l.data(e.body,"scrollUp")||(l.data(e.body,"scrollUp",!0),l.fn.scrollUp.init(o))},l.fn.scrollUp.init=function(r){var s,t,c,i,n,a,d,p=l.fn.scrollUp.settings=l.extend({},l.fn.scrollUp.defaults,r),f=!1;switch(d=p.scrollTrigger?l(p.scrollTrigger):l("<a/>",{id:p.scrollName,href:"#top"}),p.scrollTitle&&d.attr("title",p.scrollTitle),d.appendTo("body"),p.scrollImg||p.scrollTrigger||d.html(p.scrollText),d.css({display:"none",position:"fixed",zIndex:p.zIndex}),p.activeOverlay&&l("<div/>",{id:p.scrollName+"-active"}).css({position:"absolute",top:p.scrollDistance+"px",width:"100%",borderTop:"1px dotted"+p.activeOverlay,zIndex:p.zIndex}).appendTo("body"),p.animation){case"fade":s="fadeIn",t="fadeOut",c=p.animationSpeed;break;case"slide":s="slideDown",t="slideUp",c=p.animationSpeed;break;default:s="show",t="hide",c=0}i="top"===p.scrollFrom?p.scrollDistance:l(e).height()-l(o).height()-p.scrollDistance,n=l(o).scroll(function(){l(o).scrollTop()>i?f||(d[s](c),f=!0):f&&(d[t](c),f=!1)}),p.scrollTarget?"number"==typeof p.scrollTarget?a=p.scrollTarget:"string"==typeof p.scrollTarget&&(a=Math.floor(l(p.scrollTarget).offset().top)):a=0,d.click(function(o){o.preventDefault(),l("html, body").animate({scrollTop:a},p.scrollSpeed,p.easingType)})},l.fn.scrollUp.defaults={scrollName:"scrollUp",scrollDistance:300,scrollFrom:"top",scrollSpeed:300,easingType:"linear",animation:"fade",animationSpeed:200,scrollTrigger:!1,scrollTarget:!1,scrollText:"Scroll to top",scrollTitle:!1,scrollImg:!1,activeOverlay:!1,zIndex:2147483647},l.fn.scrollUp.destroy=function(r){l.removeData(e.body,"scrollUp"),l("#"+l.fn.scrollUp.settings.scrollName).remove(),l("#"+l.fn.scrollUp.settings.scrollName+"-active").remove(),l.fn.jquery.split(".")[1]>=7?l(o).off("scroll",r):l(o).unbind("scroll",r)},l.scrollUp=l.fn.scrollUp}(jQuery,window,document);




/*-------------------------------------------------------------
  03. WOW / scrolling animation
---------------------------------------------------------------*/

/*! WOW - v1.1.2 - 2015-08-19
* Copyright (c) 2015 Matthieu Aussaguel; Licensed MIT */(function(){var a,b,c,d,e,f=function(a,b){return function(){return a.apply(b,arguments)}},g=[].indexOf||function(a){for(var b=0,c=this.length;c>b;b++)if(b in this&&this[b]===a)return b;return-1};b=function(){function a(){}return a.prototype.extend=function(a,b){var c,d;for(c in b)d=b[c],null==a[c]&&(a[c]=d);return a},a.prototype.isMobile=function(a){return/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(a)},a.prototype.createEvent=function(a,b,c,d){var e;return null==b&&(b=!1),null==c&&(c=!1),null==d&&(d=null),null!=document.createEvent?(e=document.createEvent("CustomEvent"),e.initCustomEvent(a,b,c,d)):null!=document.createEventObject?(e=document.createEventObject(),e.eventType=a):e.eventName=a,e},a.prototype.emitEvent=function(a,b){return null!=a.dispatchEvent?a.dispatchEvent(b):b in(null!=a)?a[b]():"on"+b in(null!=a)?a["on"+b]():void 0},a.prototype.addEvent=function(a,b,c){return null!=a.addEventListener?a.addEventListener(b,c,!1):null!=a.attachEvent?a.attachEvent("on"+b,c):a[b]=c},a.prototype.removeEvent=function(a,b,c){return null!=a.removeEventListener?a.removeEventListener(b,c,!1):null!=a.detachEvent?a.detachEvent("on"+b,c):delete a[b]},a.prototype.innerHeight=function(){return"innerHeight"in window?window.innerHeight:document.documentElement.clientHeight},a}(),c=this.WeakMap||this.MozWeakMap||(c=function(){function a(){this.keys=[],this.values=[]}return a.prototype.get=function(a){var b,c,d,e,f;for(f=this.keys,b=d=0,e=f.length;e>d;b=++d)if(c=f[b],c===a)return this.values[b]},a.prototype.set=function(a,b){var c,d,e,f,g;for(g=this.keys,c=e=0,f=g.length;f>e;c=++e)if(d=g[c],d===a)return void(this.values[c]=b);return this.keys.push(a),this.values.push(b)},a}()),a=this.MutationObserver||this.WebkitMutationObserver||this.MozMutationObserver||(a=function(){function a(){"undefined"!=typeof console&&null!==console&&console.warn("MutationObserver is not supported by your browser."),"undefined"!=typeof console&&null!==console&&console.warn("WOW.js cannot detect dom mutations, please call .sync() after loading new content.")}return a.notSupported=!0,a.prototype.observe=function(){},a}()),d=this.getComputedStyle||function(a){return this.getPropertyValue=function(b){var c;return"float"===b&&(b="styleFloat"),e.test(b)&&b.replace(e,function(a,b){return b.toUpperCase()}),(null!=(c=a.currentStyle)?c[b]:void 0)||null},this},e=/(\-([a-z]){1})/g,this.WOW=function(){function e(a){null==a&&(a={}),this.scrollCallback=f(this.scrollCallback,this),this.scrollHandler=f(this.scrollHandler,this),this.resetAnimation=f(this.resetAnimation,this),this.start=f(this.start,this),this.scrolled=!0,this.config=this.util().extend(a,this.defaults),null!=a.scrollContainer&&(this.config.scrollContainer=document.querySelector(a.scrollContainer)),this.animationNameCache=new c,this.wowEvent=this.util().createEvent(this.config.boxClass)}return e.prototype.defaults={boxClass:"wow",animateClass:"animated",offset:0,mobile:!0,live:!0,callback:null,scrollContainer:null},e.prototype.init=function(){var a;return this.element=window.document.documentElement,"interactive"===(a=document.readyState)||"complete"===a?this.start():this.util().addEvent(document,"DOMContentLoaded",this.start),this.finished=[]},e.prototype.start=function(){var b,c,d,e;if(this.stopped=!1,this.boxes=function(){var a,c,d,e;for(d=this.element.querySelectorAll("."+this.config.boxClass),e=[],a=0,c=d.length;c>a;a++)b=d[a],e.push(b);return e}.call(this),this.all=function(){var a,c,d,e;for(d=this.boxes,e=[],a=0,c=d.length;c>a;a++)b=d[a],e.push(b);return e}.call(this),this.boxes.length)if(this.disabled())this.resetStyle();else for(e=this.boxes,c=0,d=e.length;d>c;c++)b=e[c],this.applyStyle(b,!0);return this.disabled()||(this.util().addEvent(this.config.scrollContainer||window,"scroll",this.scrollHandler),this.util().addEvent(window,"resize",this.scrollHandler),this.interval=setInterval(this.scrollCallback,50)),this.config.live?new a(function(a){return function(b){var c,d,e,f,g;for(g=[],c=0,d=b.length;d>c;c++)f=b[c],g.push(function(){var a,b,c,d;for(c=f.addedNodes||[],d=[],a=0,b=c.length;b>a;a++)e=c[a],d.push(this.doSync(e));return d}.call(a));return g}}(this)).observe(document.body,{childList:!0,subtree:!0}):void 0},e.prototype.stop=function(){return this.stopped=!0,this.util().removeEvent(this.config.scrollContainer||window,"scroll",this.scrollHandler),this.util().removeEvent(window,"resize",this.scrollHandler),null!=this.interval?clearInterval(this.interval):void 0},e.prototype.sync=function(){return a.notSupported?this.doSync(this.element):void 0},e.prototype.doSync=function(a){var b,c,d,e,f;if(null==a&&(a=this.element),1===a.nodeType){for(a=a.parentNode||a,e=a.querySelectorAll("."+this.config.boxClass),f=[],c=0,d=e.length;d>c;c++)b=e[c],g.call(this.all,b)<0?(this.boxes.push(b),this.all.push(b),this.stopped||this.disabled()?this.resetStyle():this.applyStyle(b,!0),f.push(this.scrolled=!0)):f.push(void 0);return f}},e.prototype.show=function(a){return this.applyStyle(a),a.className=a.className+" "+this.config.animateClass,null!=this.config.callback&&this.config.callback(a),this.util().emitEvent(a,this.wowEvent),this.util().addEvent(a,"animationend",this.resetAnimation),this.util().addEvent(a,"oanimationend",this.resetAnimation),this.util().addEvent(a,"webkitAnimationEnd",this.resetAnimation),this.util().addEvent(a,"MSAnimationEnd",this.resetAnimation),a},e.prototype.applyStyle=function(a,b){var c,d,e;return d=a.getAttribute("data-wow-duration"),c=a.getAttribute("data-wow-delay"),e=a.getAttribute("data-wow-iteration"),this.animate(function(f){return function(){return f.customStyle(a,b,d,c,e)}}(this))},e.prototype.animate=function(){return"requestAnimationFrame"in window?function(a){return window.requestAnimationFrame(a)}:function(a){return a()}}(),e.prototype.resetStyle=function(){var a,b,c,d,e;for(d=this.boxes,e=[],b=0,c=d.length;c>b;b++)a=d[b],e.push(a.style.visibility="visible");return e},e.prototype.resetAnimation=function(a){var b;return a.type.toLowerCase().indexOf("animationend")>=0?(b=a.target||a.srcElement,b.className=b.className.replace(this.config.animateClass,"").trim()):void 0},e.prototype.customStyle=function(a,b,c,d,e){return b&&this.cacheAnimationName(a),a.style.visibility=b?"hidden":"visible",c&&this.vendorSet(a.style,{animationDuration:c}),d&&this.vendorSet(a.style,{animationDelay:d}),e&&this.vendorSet(a.style,{animationIterationCount:e}),this.vendorSet(a.style,{animationName:b?"none":this.cachedAnimationName(a)}),a},e.prototype.vendors=["moz","webkit"],e.prototype.vendorSet=function(a,b){var c,d,e,f;d=[];for(c in b)e=b[c],a[""+c]=e,d.push(function(){var b,d,g,h;for(g=this.vendors,h=[],b=0,d=g.length;d>b;b++)f=g[b],h.push(a[""+f+c.charAt(0).toUpperCase()+c.substr(1)]=e);return h}.call(this));return d},e.prototype.vendorCSS=function(a,b){var c,e,f,g,h,i;for(h=d(a),g=h.getPropertyCSSValue(b),f=this.vendors,c=0,e=f.length;e>c;c++)i=f[c],g=g||h.getPropertyCSSValue("-"+i+"-"+b);return g},e.prototype.animationName=function(a){var b;try{b=this.vendorCSS(a,"animation-name").cssText}catch(c){b=d(a).getPropertyValue("animation-name")}return"none"===b?"":b},e.prototype.cacheAnimationName=function(a){return this.animationNameCache.set(a,this.animationName(a))},e.prototype.cachedAnimationName=function(a){return this.animationNameCache.get(a)},e.prototype.scrollHandler=function(){return this.scrolled=!0},e.prototype.scrollCallback=function(){var a;return!this.scrolled||(this.scrolled=!1,this.boxes=function(){var b,c,d,e;for(d=this.boxes,e=[],b=0,c=d.length;c>b;b++)a=d[b],a&&(this.isVisible(a)?this.show(a):e.push(a));return e}.call(this),this.boxes.length||this.config.live)?void 0:this.stop()},e.prototype.offsetTop=function(a){for(var b;void 0===a.offsetTop;)a=a.parentNode;for(b=a.offsetTop;a=a.offsetParent;)b+=a.offsetTop;return b},e.prototype.isVisible=function(a){var b,c,d,e,f;return c=a.getAttribute("data-wow-offset")||this.config.offset,f=this.config.scrollContainer&&this.config.scrollContainer.scrollTop||window.pageYOffset,e=f+Math.min(this.element.clientHeight,this.util().innerHeight())-c,d=this.offsetTop(a),b=d+a.clientHeight,e>=d&&b>=f},e.prototype.util=function(){return null!=this._util?this._util:this._util=new b},e.prototype.disabled=function(){return!this.config.mobile&&this.util().isMobile(navigator.userAgent)},e}()}).call(this);


/*-------------------------------------------------------------
  04. Isotope PACKAGED v2.2.0
---------------------------------------------------------------*/

/*!
 * imagesLoaded PACKAGED v3.1.8
 * JavaScript is all like "You images are done yet or what?"
 * MIT License
 */

(function(){function e(){}function t(e,t){for(var n=e.length;n--;)if(e[n].listener===t)return n;return-1}function n(e){return function(){return this[e].apply(this,arguments)}}var i=e.prototype,r=this,o=r.EventEmitter;i.getListeners=function(e){var t,n,i=this._getEvents();if("object"==typeof e){t={};for(n in i)i.hasOwnProperty(n)&&e.test(n)&&(t[n]=i[n])}else t=i[e]||(i[e]=[]);return t},i.flattenListeners=function(e){var t,n=[];for(t=0;e.length>t;t+=1)n.push(e[t].listener);return n},i.getListenersAsObject=function(e){var t,n=this.getListeners(e);return n instanceof Array&&(t={},t[e]=n),t||n},i.addListener=function(e,n){var i,r=this.getListenersAsObject(e),o="object"==typeof n;for(i in r)r.hasOwnProperty(i)&&-1===t(r[i],n)&&r[i].push(o?n:{listener:n,once:!1});return this},i.on=n("addListener"),i.addOnceListener=function(e,t){return this.addListener(e,{listener:t,once:!0})},i.once=n("addOnceListener"),i.defineEvent=function(e){return this.getListeners(e),this},i.defineEvents=function(e){for(var t=0;e.length>t;t+=1)this.defineEvent(e[t]);return this},i.removeListener=function(e,n){var i,r,o=this.getListenersAsObject(e);for(r in o)o.hasOwnProperty(r)&&(i=t(o[r],n),-1!==i&&o[r].splice(i,1));return this},i.off=n("removeListener"),i.addListeners=function(e,t){return this.manipulateListeners(!1,e,t)},i.removeListeners=function(e,t){return this.manipulateListeners(!0,e,t)},i.manipulateListeners=function(e,t,n){var i,r,o=e?this.removeListener:this.addListener,s=e?this.removeListeners:this.addListeners;if("object"!=typeof t||t instanceof RegExp)for(i=n.length;i--;)o.call(this,t,n[i]);else for(i in t)t.hasOwnProperty(i)&&(r=t[i])&&("function"==typeof r?o.call(this,i,r):s.call(this,i,r));return this},i.removeEvent=function(e){var t,n=typeof e,i=this._getEvents();if("string"===n)delete i[e];else if("object"===n)for(t in i)i.hasOwnProperty(t)&&e.test(t)&&delete i[t];else delete this._events;return this},i.removeAllListeners=n("removeEvent"),i.emitEvent=function(e,t){var n,i,r,o,s=this.getListenersAsObject(e);for(r in s)if(s.hasOwnProperty(r))for(i=s[r].length;i--;)n=s[r][i],n.once===!0&&this.removeListener(e,n.listener),o=n.listener.apply(this,t||[]),o===this._getOnceReturnValue()&&this.removeListener(e,n.listener);return this},i.trigger=n("emitEvent"),i.emit=function(e){var t=Array.prototype.slice.call(arguments,1);return this.emitEvent(e,t)},i.setOnceReturnValue=function(e){return this._onceReturnValue=e,this},i._getOnceReturnValue=function(){return this.hasOwnProperty("_onceReturnValue")?this._onceReturnValue:!0},i._getEvents=function(){return this._events||(this._events={})},e.noConflict=function(){return r.EventEmitter=o,e},"function"==typeof define&&define.amd?define("eventEmitter/EventEmitter",[],function(){return e}):"object"==typeof module&&module.exports?module.exports=e:this.EventEmitter=e}).call(this),function(e){function t(t){var n=e.event;return n.target=n.target||n.srcElement||t,n}var n=document.documentElement,i=function(){};n.addEventListener?i=function(e,t,n){e.addEventListener(t,n,!1)}:n.attachEvent&&(i=function(e,n,i){e[n+i]=i.handleEvent?function(){var n=t(e);i.handleEvent.call(i,n)}:function(){var n=t(e);i.call(e,n)},e.attachEvent("on"+n,e[n+i])});var r=function(){};n.removeEventListener?r=function(e,t,n){e.removeEventListener(t,n,!1)}:n.detachEvent&&(r=function(e,t,n){e.detachEvent("on"+t,e[t+n]);try{delete e[t+n]}catch(i){e[t+n]=void 0}});var o={bind:i,unbind:r};"function"==typeof define&&define.amd?define("eventie/eventie",o):e.eventie=o}(this),function(e,t){"function"==typeof define&&define.amd?define(["eventEmitter/EventEmitter","eventie/eventie"],function(n,i){return t(e,n,i)}):"object"==typeof exports?module.exports=t(e,require("wolfy87-eventemitter"),require("eventie")):e.imagesLoaded=t(e,e.EventEmitter,e.eventie)}(window,function(e,t,n){function i(e,t){for(var n in t)e[n]=t[n];return e}function r(e){return"[object Array]"===d.call(e)}function o(e){var t=[];if(r(e))t=e;else if("number"==typeof e.length)for(var n=0,i=e.length;i>n;n++)t.push(e[n]);else t.push(e);return t}function s(e,t,n){if(!(this instanceof s))return new s(e,t);"string"==typeof e&&(e=document.querySelectorAll(e)),this.elements=o(e),this.options=i({},this.options),"function"==typeof t?n=t:i(this.options,t),n&&this.on("always",n),this.getImages(),a&&(this.jqDeferred=new a.Deferred);var r=this;setTimeout(function(){r.check()})}function f(e){this.img=e}function c(e){this.src=e,v[e]=this}var a=e.jQuery,u=e.console,h=u!==void 0,d=Object.prototype.toString;s.prototype=new t,s.prototype.options={},s.prototype.getImages=function(){this.images=[];for(var e=0,t=this.elements.length;t>e;e++){var n=this.elements[e];"IMG"===n.nodeName&&this.addImage(n);var i=n.nodeType;if(i&&(1===i||9===i||11===i))for(var r=n.querySelectorAll("img"),o=0,s=r.length;s>o;o++){var f=r[o];this.addImage(f)}}},s.prototype.addImage=function(e){var t=new f(e);this.images.push(t)},s.prototype.check=function(){function e(e,r){return t.options.debug&&h&&u.log("confirm",e,r),t.progress(e),n++,n===i&&t.complete(),!0}var t=this,n=0,i=this.images.length;if(this.hasAnyBroken=!1,!i)return this.complete(),void 0;for(var r=0;i>r;r++){var o=this.images[r];o.on("confirm",e),o.check()}},s.prototype.progress=function(e){this.hasAnyBroken=this.hasAnyBroken||!e.isLoaded;var t=this;setTimeout(function(){t.emit("progress",t,e),t.jqDeferred&&t.jqDeferred.notify&&t.jqDeferred.notify(t,e)})},s.prototype.complete=function(){var e=this.hasAnyBroken?"fail":"done";this.isComplete=!0;var t=this;setTimeout(function(){if(t.emit(e,t),t.emit("always",t),t.jqDeferred){var n=t.hasAnyBroken?"reject":"resolve";t.jqDeferred[n](t)}})},a&&(a.fn.imagesLoaded=function(e,t){var n=new s(this,e,t);return n.jqDeferred.promise(a(this))}),f.prototype=new t,f.prototype.check=function(){var e=v[this.img.src]||new c(this.img.src);if(e.isConfirmed)return this.confirm(e.isLoaded,"cached was confirmed"),void 0;if(this.img.complete&&void 0!==this.img.naturalWidth)return this.confirm(0!==this.img.naturalWidth,"naturalWidth"),void 0;var t=this;e.on("confirm",function(e,n){return t.confirm(e.isLoaded,n),!0}),e.check()},f.prototype.confirm=function(e,t){this.isLoaded=e,this.emit("confirm",this,t)};var v={};return c.prototype=new t,c.prototype.check=function(){if(!this.isChecked){var e=new Image;n.bind(e,"load",this),n.bind(e,"error",this),e.src=this.src,this.isChecked=!0}},c.prototype.handleEvent=function(e){var t="on"+e.type;this[t]&&this[t](e)},c.prototype.onload=function(e){this.confirm(!0,"onload"),this.unbindProxyEvents(e)},c.prototype.onerror=function(e){this.confirm(!1,"onerror"),this.unbindProxyEvents(e)},c.prototype.confirm=function(e,t){this.isConfirmed=!0,this.isLoaded=e,this.emit("confirm",this,t)},c.prototype.unbindProxyEvents=function(e){n.unbind(e.target,"load",this),n.unbind(e.target,"error",this)},s});



/*!
 * Isotope PACKAGED v2.2.0
 *
 * Licensed GPLv3 for open source use
 * or Isotope Commercial License for commercial use
 *
 * http://isotope.metafizzy.co
 * Copyright 2015 Metafizzy
 */
(function(t){function e(){}function i(t){function i(e){e.prototype.option||(e.prototype.option=function(e){t.isPlainObject(e)&&(this.options=t.extend(!0,this.options,e))})}function n(e,i){t.fn[e]=function(n){if("string"==typeof n){for(var s=o.call(arguments,1),a=0,u=this.length;u>a;a++){var p=this[a],h=t.data(p,e);if(h)if(t.isFunction(h[n])&&"_"!==n.charAt(0)){var f=h[n].apply(h,s);if(void 0!==f)return f}else r("no such method '"+n+"' for "+e+" instance");else r("cannot call methods on "+e+" prior to initialization; "+"attempted to call '"+n+"'")}return this}return this.each(function(){var o=t.data(this,e);o?(o.option(n),o._init()):(o=new i(this,n),t.data(this,e,o))})}}if(t){var r="undefined"==typeof console?e:function(t){console.error(t)};return t.bridget=function(t,e){i(e),n(t,e)},t.bridget}}var o=Array.prototype.slice;"function"==typeof define&&define.amd?define("jquery-bridget/jquery.bridget",["jquery"],i):"object"==typeof exports?i(require("jquery")):i(t.jQuery)})(window),function(t){function e(e){var i=t.event;return i.target=i.target||i.srcElement||e,i}var i=document.documentElement,o=function(){};i.addEventListener?o=function(t,e,i){t.addEventListener(e,i,!1)}:i.attachEvent&&(o=function(t,i,o){t[i+o]=o.handleEvent?function(){var i=e(t);o.handleEvent.call(o,i)}:function(){var i=e(t);o.call(t,i)},t.attachEvent("on"+i,t[i+o])});var n=function(){};i.removeEventListener?n=function(t,e,i){t.removeEventListener(e,i,!1)}:i.detachEvent&&(n=function(t,e,i){t.detachEvent("on"+e,t[e+i]);try{delete t[e+i]}catch(o){t[e+i]=void 0}});var r={bind:o,unbind:n};"function"==typeof define&&define.amd?define("eventie/eventie",r):"object"==typeof exports?module.exports=r:t.eventie=r}(window),function(){function t(){}function e(t,e){for(var i=t.length;i--;)if(t[i].listener===e)return i;return-1}function i(t){return function(){return this[t].apply(this,arguments)}}var o=t.prototype,n=this,r=n.EventEmitter;o.getListeners=function(t){var e,i,o=this._getEvents();if(t instanceof RegExp){e={};for(i in o)o.hasOwnProperty(i)&&t.test(i)&&(e[i]=o[i])}else e=o[t]||(o[t]=[]);return e},o.flattenListeners=function(t){var e,i=[];for(e=0;t.length>e;e+=1)i.push(t[e].listener);return i},o.getListenersAsObject=function(t){var e,i=this.getListeners(t);return i instanceof Array&&(e={},e[t]=i),e||i},o.addListener=function(t,i){var o,n=this.getListenersAsObject(t),r="object"==typeof i;for(o in n)n.hasOwnProperty(o)&&-1===e(n[o],i)&&n[o].push(r?i:{listener:i,once:!1});return this},o.on=i("addListener"),o.addOnceListener=function(t,e){return this.addListener(t,{listener:e,once:!0})},o.once=i("addOnceListener"),o.defineEvent=function(t){return this.getListeners(t),this},o.defineEvents=function(t){for(var e=0;t.length>e;e+=1)this.defineEvent(t[e]);return this},o.removeListener=function(t,i){var o,n,r=this.getListenersAsObject(t);for(n in r)r.hasOwnProperty(n)&&(o=e(r[n],i),-1!==o&&r[n].splice(o,1));return this},o.off=i("removeListener"),o.addListeners=function(t,e){return this.manipulateListeners(!1,t,e)},o.removeListeners=function(t,e){return this.manipulateListeners(!0,t,e)},o.manipulateListeners=function(t,e,i){var o,n,r=t?this.removeListener:this.addListener,s=t?this.removeListeners:this.addListeners;if("object"!=typeof e||e instanceof RegExp)for(o=i.length;o--;)r.call(this,e,i[o]);else for(o in e)e.hasOwnProperty(o)&&(n=e[o])&&("function"==typeof n?r.call(this,o,n):s.call(this,o,n));return this},o.removeEvent=function(t){var e,i=typeof t,o=this._getEvents();if("string"===i)delete o[t];else if(t instanceof RegExp)for(e in o)o.hasOwnProperty(e)&&t.test(e)&&delete o[e];else delete this._events;return this},o.removeAllListeners=i("removeEvent"),o.emitEvent=function(t,e){var i,o,n,r,s=this.getListenersAsObject(t);for(n in s)if(s.hasOwnProperty(n))for(o=s[n].length;o--;)i=s[n][o],i.once===!0&&this.removeListener(t,i.listener),r=i.listener.apply(this,e||[]),r===this._getOnceReturnValue()&&this.removeListener(t,i.listener);return this},o.trigger=i("emitEvent"),o.emit=function(t){var e=Array.prototype.slice.call(arguments,1);return this.emitEvent(t,e)},o.setOnceReturnValue=function(t){return this._onceReturnValue=t,this},o._getOnceReturnValue=function(){return this.hasOwnProperty("_onceReturnValue")?this._onceReturnValue:!0},o._getEvents=function(){return this._events||(this._events={})},t.noConflict=function(){return n.EventEmitter=r,t},"function"==typeof define&&define.amd?define("eventEmitter/EventEmitter",[],function(){return t}):"object"==typeof module&&module.exports?module.exports=t:n.EventEmitter=t}.call(this),function(t){function e(t){if(t){if("string"==typeof o[t])return t;t=t.charAt(0).toUpperCase()+t.slice(1);for(var e,n=0,r=i.length;r>n;n++)if(e=i[n]+t,"string"==typeof o[e])return e}}var i="Webkit Moz ms Ms O".split(" "),o=document.documentElement.style;"function"==typeof define&&define.amd?define("get-style-property/get-style-property",[],function(){return e}):"object"==typeof exports?module.exports=e:t.getStyleProperty=e}(window),function(t){function e(t){var e=parseFloat(t),i=-1===t.indexOf("%")&&!isNaN(e);return i&&e}function i(){}function o(){for(var t={width:0,height:0,innerWidth:0,innerHeight:0,outerWidth:0,outerHeight:0},e=0,i=s.length;i>e;e++){var o=s[e];t[o]=0}return t}function n(i){function n(){if(!d){d=!0;var o=t.getComputedStyle;if(p=function(){var t=o?function(t){return o(t,null)}:function(t){return t.currentStyle};return function(e){var i=t(e);return i||r("Style returned "+i+". Are you running this code in a hidden iframe on Firefox? "+"See http://bit.ly/getsizebug1"),i}}(),h=i("boxSizing")){var n=document.createElement("div");n.style.width="200px",n.style.padding="1px 2px 3px 4px",n.style.borderStyle="solid",n.style.borderWidth="1px 2px 3px 4px",n.style[h]="border-box";var s=document.body||document.documentElement;s.appendChild(n);var a=p(n);f=200===e(a.width),s.removeChild(n)}}}function a(t){if(n(),"string"==typeof t&&(t=document.querySelector(t)),t&&"object"==typeof t&&t.nodeType){var i=p(t);if("none"===i.display)return o();var r={};r.width=t.offsetWidth,r.height=t.offsetHeight;for(var a=r.isBorderBox=!(!h||!i[h]||"border-box"!==i[h]),d=0,l=s.length;l>d;d++){var c=s[d],m=i[c];m=u(t,m);var y=parseFloat(m);r[c]=isNaN(y)?0:y}var g=r.paddingLeft+r.paddingRight,v=r.paddingTop+r.paddingBottom,_=r.marginLeft+r.marginRight,I=r.marginTop+r.marginBottom,z=r.borderLeftWidth+r.borderRightWidth,L=r.borderTopWidth+r.borderBottomWidth,x=a&&f,E=e(i.width);E!==!1&&(r.width=E+(x?0:g+z));var b=e(i.height);return b!==!1&&(r.height=b+(x?0:v+L)),r.innerWidth=r.width-(g+z),r.innerHeight=r.height-(v+L),r.outerWidth=r.width+_,r.outerHeight=r.height+I,r}}function u(e,i){if(t.getComputedStyle||-1===i.indexOf("%"))return i;var o=e.style,n=o.left,r=e.runtimeStyle,s=r&&r.left;return s&&(r.left=e.currentStyle.left),o.left=i,i=o.pixelLeft,o.left=n,s&&(r.left=s),i}var p,h,f,d=!1;return a}var r="undefined"==typeof console?i:function(t){console.error(t)},s=["paddingLeft","paddingRight","paddingTop","paddingBottom","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth"];"function"==typeof define&&define.amd?define("get-size/get-size",["get-style-property/get-style-property"],n):"object"==typeof exports?module.exports=n(require("desandro-get-style-property")):t.getSize=n(t.getStyleProperty)}(window),function(t){function e(t){"function"==typeof t&&(e.isReady?t():s.push(t))}function i(t){var i="readystatechange"===t.type&&"complete"!==r.readyState;e.isReady||i||o()}function o(){e.isReady=!0;for(var t=0,i=s.length;i>t;t++){var o=s[t];o()}}function n(n){return"complete"===r.readyState?o():(n.bind(r,"DOMContentLoaded",i),n.bind(r,"readystatechange",i),n.bind(t,"load",i)),e}var r=t.document,s=[];e.isReady=!1,"function"==typeof define&&define.amd?define("doc-ready/doc-ready",["eventie/eventie"],n):"object"==typeof exports?module.exports=n(require("eventie")):t.docReady=n(t.eventie)}(window),function(t){function e(t,e){return t[s](e)}function i(t){if(!t.parentNode){var e=document.createDocumentFragment();e.appendChild(t)}}function o(t,e){i(t);for(var o=t.parentNode.querySelectorAll(e),n=0,r=o.length;r>n;n++)if(o[n]===t)return!0;return!1}function n(t,o){return i(t),e(t,o)}var r,s=function(){if(t.matches)return"matches";if(t.matchesSelector)return"matchesSelector";for(var e=["webkit","moz","ms","o"],i=0,o=e.length;o>i;i++){var n=e[i],r=n+"MatchesSelector";if(t[r])return r}}();if(s){var a=document.createElement("div"),u=e(a,"div");r=u?e:n}else r=o;"function"==typeof define&&define.amd?define("matches-selector/matches-selector",[],function(){return r}):"object"==typeof exports?module.exports=r:window.matchesSelector=r}(Element.prototype),function(t,e){"function"==typeof define&&define.amd?define("fizzy-ui-utils/utils",["doc-ready/doc-ready","matches-selector/matches-selector"],function(i,o){return e(t,i,o)}):"object"==typeof exports?module.exports=e(t,require("doc-ready"),require("desandro-matches-selector")):t.fizzyUIUtils=e(t,t.docReady,t.matchesSelector)}(window,function(t,e,i){var o={};o.extend=function(t,e){for(var i in e)t[i]=e[i];return t},o.modulo=function(t,e){return(t%e+e)%e};var n=Object.prototype.toString;o.isArray=function(t){return"[object Array]"==n.call(t)},o.makeArray=function(t){var e=[];if(o.isArray(t))e=t;else if(t&&"number"==typeof t.length)for(var i=0,n=t.length;n>i;i++)e.push(t[i]);else e.push(t);return e},o.indexOf=Array.prototype.indexOf?function(t,e){return t.indexOf(e)}:function(t,e){for(var i=0,o=t.length;o>i;i++)if(t[i]===e)return i;return-1},o.removeFrom=function(t,e){var i=o.indexOf(t,e);-1!=i&&t.splice(i,1)},o.isElement="function"==typeof HTMLElement||"object"==typeof HTMLElement?function(t){return t instanceof HTMLElement}:function(t){return t&&"object"==typeof t&&1==t.nodeType&&"string"==typeof t.nodeName},o.setText=function(){function t(t,i){e=e||(void 0!==document.documentElement.textContent?"textContent":"innerText"),t[e]=i}var e;return t}(),o.getParent=function(t,e){for(;t!=document.body;)if(t=t.parentNode,i(t,e))return t},o.getQueryElement=function(t){return"string"==typeof t?document.querySelector(t):t},o.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},o.filterFindElements=function(t,e){t=o.makeArray(t);for(var n=[],r=0,s=t.length;s>r;r++){var a=t[r];if(o.isElement(a))if(e){i(a,e)&&n.push(a);for(var u=a.querySelectorAll(e),p=0,h=u.length;h>p;p++)n.push(u[p])}else n.push(a)}return n},o.debounceMethod=function(t,e,i){var o=t.prototype[e],n=e+"Timeout";t.prototype[e]=function(){var t=this[n];t&&clearTimeout(t);var e=arguments,r=this;this[n]=setTimeout(function(){o.apply(r,e),delete r[n]},i||100)}},o.toDashed=function(t){return t.replace(/(.)([A-Z])/g,function(t,e,i){return e+"-"+i}).toLowerCase()};var r=t.console;return o.htmlInit=function(i,n){e(function(){for(var e=o.toDashed(n),s=document.querySelectorAll(".js-"+e),a="data-"+e+"-options",u=0,p=s.length;p>u;u++){var h,f=s[u],d=f.getAttribute(a);try{h=d&&JSON.parse(d)}catch(l){r&&r.error("Error parsing "+a+" on "+f.nodeName.toLowerCase()+(f.id?"#"+f.id:"")+": "+l);continue}var c=new i(f,h),m=t.jQuery;m&&m.data(f,n,c)}})},o}),function(t,e){"function"==typeof define&&define.amd?define("outlayer/item",["eventEmitter/EventEmitter","get-size/get-size","get-style-property/get-style-property","fizzy-ui-utils/utils"],function(i,o,n,r){return e(t,i,o,n,r)}):"object"==typeof exports?module.exports=e(t,require("wolfy87-eventemitter"),require("get-size"),require("desandro-get-style-property"),require("fizzy-ui-utils")):(t.Outlayer={},t.Outlayer.Item=e(t,t.EventEmitter,t.getSize,t.getStyleProperty,t.fizzyUIUtils))}(window,function(t,e,i,o,n){function r(t){for(var e in t)return!1;return e=null,!0}function s(t,e){t&&(this.element=t,this.layout=e,this.position={x:0,y:0},this._create())}var a=t.getComputedStyle,u=a?function(t){return a(t,null)}:function(t){return t.currentStyle},p=o("transition"),h=o("transform"),f=p&&h,d=!!o("perspective"),l={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"otransitionend",transition:"transitionend"}[p],c=["transform","transition","transitionDuration","transitionProperty"],m=function(){for(var t={},e=0,i=c.length;i>e;e++){var n=c[e],r=o(n);r&&r!==n&&(t[n]=r)}return t}();n.extend(s.prototype,e.prototype),s.prototype._create=function(){this._transn={ingProperties:{},clean:{},onEnd:{}},this.css({position:"absolute"})},s.prototype.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},s.prototype.getSize=function(){this.size=i(this.element)},s.prototype.css=function(t){var e=this.element.style;for(var i in t){var o=m[i]||i;e[o]=t[i]}},s.prototype.getPosition=function(){var t=u(this.element),e=this.layout.options,i=e.isOriginLeft,o=e.isOriginTop,n=parseInt(t[i?"left":"right"],10),r=parseInt(t[o?"top":"bottom"],10);n=isNaN(n)?0:n,r=isNaN(r)?0:r;var s=this.layout.size;n-=i?s.paddingLeft:s.paddingRight,r-=o?s.paddingTop:s.paddingBottom,this.position.x=n,this.position.y=r},s.prototype.layoutPosition=function(){var t=this.layout.size,e=this.layout.options,i={},o=e.isOriginLeft?"paddingLeft":"paddingRight",n=e.isOriginLeft?"left":"right",r=e.isOriginLeft?"right":"left",s=this.position.x+t[o];s=e.percentPosition&&!e.isHorizontal?100*(s/t.width)+"%":s+"px",i[n]=s,i[r]="";var a=e.isOriginTop?"paddingTop":"paddingBottom",u=e.isOriginTop?"top":"bottom",p=e.isOriginTop?"bottom":"top",h=this.position.y+t[a];h=e.percentPosition&&e.isHorizontal?100*(h/t.height)+"%":h+"px",i[u]=h,i[p]="",this.css(i),this.emitEvent("layout",[this])};var y=d?function(t,e){return"translate3d("+t+"px, "+e+"px, 0)"}:function(t,e){return"translate("+t+"px, "+e+"px)"};s.prototype._transitionTo=function(t,e){this.getPosition();var i=this.position.x,o=this.position.y,n=parseInt(t,10),r=parseInt(e,10),s=n===this.position.x&&r===this.position.y;if(this.setPosition(t,e),s&&!this.isTransitioning)return this.layoutPosition(),void 0;var a=t-i,u=e-o,p={},h=this.layout.options;a=h.isOriginLeft?a:-a,u=h.isOriginTop?u:-u,p.transform=y(a,u),this.transition({to:p,onTransitionEnd:{transform:this.layoutPosition},isCleaning:!0})},s.prototype.goTo=function(t,e){this.setPosition(t,e),this.layoutPosition()},s.prototype.moveTo=f?s.prototype._transitionTo:s.prototype.goTo,s.prototype.setPosition=function(t,e){this.position.x=parseInt(t,10),this.position.y=parseInt(e,10)},s.prototype._nonTransition=function(t){this.css(t.to),t.isCleaning&&this._removeStyles(t.to);for(var e in t.onTransitionEnd)t.onTransitionEnd[e].call(this)},s.prototype._transition=function(t){if(!parseFloat(this.layout.options.transitionDuration))return this._nonTransition(t),void 0;var e=this._transn;for(var i in t.onTransitionEnd)e.onEnd[i]=t.onTransitionEnd[i];for(i in t.to)e.ingProperties[i]=!0,t.isCleaning&&(e.clean[i]=!0);if(t.from){this.css(t.from);var o=this.element.offsetHeight;o=null}this.enableTransition(t.to),this.css(t.to),this.isTransitioning=!0};var g=h&&n.toDashed(h)+",opacity";s.prototype.enableTransition=function(){this.isTransitioning||(this.css({transitionProperty:g,transitionDuration:this.layout.options.transitionDuration}),this.element.addEventListener(l,this,!1))},s.prototype.transition=s.prototype[p?"_transition":"_nonTransition"],s.prototype.onwebkitTransitionEnd=function(t){this.ontransitionend(t)},s.prototype.onotransitionend=function(t){this.ontransitionend(t)};var v={"-webkit-transform":"transform","-moz-transform":"transform","-o-transform":"transform"};s.prototype.ontransitionend=function(t){if(t.target===this.element){var e=this._transn,i=v[t.propertyName]||t.propertyName;if(delete e.ingProperties[i],r(e.ingProperties)&&this.disableTransition(),i in e.clean&&(this.element.style[t.propertyName]="",delete e.clean[i]),i in e.onEnd){var o=e.onEnd[i];o.call(this),delete e.onEnd[i]}this.emitEvent("transitionEnd",[this])}},s.prototype.disableTransition=function(){this.removeTransitionStyles(),this.element.removeEventListener(l,this,!1),this.isTransitioning=!1},s.prototype._removeStyles=function(t){var e={};for(var i in t)e[i]="";this.css(e)};var _={transitionProperty:"",transitionDuration:""};return s.prototype.removeTransitionStyles=function(){this.css(_)},s.prototype.removeElem=function(){this.element.parentNode.removeChild(this.element),this.css({display:""}),this.emitEvent("remove",[this])},s.prototype.remove=function(){if(!p||!parseFloat(this.layout.options.transitionDuration))return this.removeElem(),void 0;var t=this;this.once("transitionEnd",function(){t.removeElem()}),this.hide()},s.prototype.reveal=function(){delete this.isHidden,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("visibleStyle");e[i]=this.onRevealTransitionEnd,this.transition({from:t.hiddenStyle,to:t.visibleStyle,isCleaning:!0,onTransitionEnd:e})},s.prototype.onRevealTransitionEnd=function(){this.isHidden||this.emitEvent("reveal")},s.prototype.getHideRevealTransitionEndProperty=function(t){var e=this.layout.options[t];if(e.opacity)return"opacity";for(var i in e)return i},s.prototype.hide=function(){this.isHidden=!0,this.css({display:""});var t=this.layout.options,e={},i=this.getHideRevealTransitionEndProperty("hiddenStyle");e[i]=this.onHideTransitionEnd,this.transition({from:t.visibleStyle,to:t.hiddenStyle,isCleaning:!0,onTransitionEnd:e})},s.prototype.onHideTransitionEnd=function(){this.isHidden&&(this.css({display:"none"}),this.emitEvent("hide"))},s.prototype.destroy=function(){this.css({position:"",left:"",right:"",top:"",bottom:"",transition:"",transform:""})},s}),function(t,e){"function"==typeof define&&define.amd?define("outlayer/outlayer",["eventie/eventie","eventEmitter/EventEmitter","get-size/get-size","fizzy-ui-utils/utils","./item"],function(i,o,n,r,s){return e(t,i,o,n,r,s)}):"object"==typeof exports?module.exports=e(t,require("eventie"),require("wolfy87-eventemitter"),require("get-size"),require("fizzy-ui-utils"),require("./item")):t.Outlayer=e(t,t.eventie,t.EventEmitter,t.getSize,t.fizzyUIUtils,t.Outlayer.Item)}(window,function(t,e,i,o,n,r){function s(t,e){var i=n.getQueryElement(t);if(!i)return a&&a.error("Bad element for "+this.constructor.namespace+": "+(i||t)),void 0;this.element=i,u&&(this.$element=u(this.element)),this.options=n.extend({},this.constructor.defaults),this.option(e);var o=++h;this.element.outlayerGUID=o,f[o]=this,this._create(),this.options.isInitLayout&&this.layout()}var a=t.console,u=t.jQuery,p=function(){},h=0,f={};return s.namespace="outlayer",s.Item=r,s.defaults={containerStyle:{position:"relative"},isInitLayout:!0,isOriginLeft:!0,isOriginTop:!0,isResizeBound:!0,isResizingContainer:!0,transitionDuration:"0.4s",hiddenStyle:{opacity:0,transform:"scale(0.001)"},visibleStyle:{opacity:1,transform:"scale(1)"}},n.extend(s.prototype,i.prototype),s.prototype.option=function(t){n.extend(this.options,t)},s.prototype._create=function(){this.reloadItems(),this.stamps=[],this.stamp(this.options.stamp),n.extend(this.element.style,this.options.containerStyle),this.options.isResizeBound&&this.bindResize()},s.prototype.reloadItems=function(){this.items=this._itemize(this.element.children)},s.prototype._itemize=function(t){for(var e=this._filterFindItemElements(t),i=this.constructor.Item,o=[],n=0,r=e.length;r>n;n++){var s=e[n],a=new i(s,this);o.push(a)}return o},s.prototype._filterFindItemElements=function(t){return n.filterFindElements(t,this.options.itemSelector)},s.prototype.getItemElements=function(){for(var t=[],e=0,i=this.items.length;i>e;e++)t.push(this.items[e].element);return t},s.prototype.layout=function(){this._resetLayout(),this._manageStamps();var t=void 0!==this.options.isLayoutInstant?this.options.isLayoutInstant:!this._isLayoutInited;this.layoutItems(this.items,t),this._isLayoutInited=!0},s.prototype._init=s.prototype.layout,s.prototype._resetLayout=function(){this.getSize()},s.prototype.getSize=function(){this.size=o(this.element)},s.prototype._getMeasurement=function(t,e){var i,r=this.options[t];r?("string"==typeof r?i=this.element.querySelector(r):n.isElement(r)&&(i=r),this[t]=i?o(i)[e]:r):this[t]=0},s.prototype.layoutItems=function(t,e){t=this._getItemsForLayout(t),this._layoutItems(t,e),this._postLayout()},s.prototype._getItemsForLayout=function(t){for(var e=[],i=0,o=t.length;o>i;i++){var n=t[i];n.isIgnored||e.push(n)}return e},s.prototype._layoutItems=function(t,e){if(this._emitCompleteOnItems("layout",t),t&&t.length){for(var i=[],o=0,n=t.length;n>o;o++){var r=t[o],s=this._getItemLayoutPosition(r);s.item=r,s.isInstant=e||r.isLayoutInstant,i.push(s)}this._processLayoutQueue(i)}},s.prototype._getItemLayoutPosition=function(){return{x:0,y:0}},s.prototype._processLayoutQueue=function(t){for(var e=0,i=t.length;i>e;e++){var o=t[e];this._positionItem(o.item,o.x,o.y,o.isInstant)}},s.prototype._positionItem=function(t,e,i,o){o?t.goTo(e,i):t.moveTo(e,i)},s.prototype._postLayout=function(){this.resizeContainer()},s.prototype.resizeContainer=function(){if(this.options.isResizingContainer){var t=this._getContainerSize();t&&(this._setContainerMeasure(t.width,!0),this._setContainerMeasure(t.height,!1))}},s.prototype._getContainerSize=p,s.prototype._setContainerMeasure=function(t,e){if(void 0!==t){var i=this.size;i.isBorderBox&&(t+=e?i.paddingLeft+i.paddingRight+i.borderLeftWidth+i.borderRightWidth:i.paddingBottom+i.paddingTop+i.borderTopWidth+i.borderBottomWidth),t=Math.max(t,0),this.element.style[e?"width":"height"]=t+"px"}},s.prototype._emitCompleteOnItems=function(t,e){function i(){n.emitEvent(t+"Complete",[e])}function o(){s++,s===r&&i()}var n=this,r=e.length;if(!e||!r)return i(),void 0;for(var s=0,a=0,u=e.length;u>a;a++){var p=e[a];p.once(t,o)}},s.prototype.ignore=function(t){var e=this.getItem(t);e&&(e.isIgnored=!0)},s.prototype.unignore=function(t){var e=this.getItem(t);e&&delete e.isIgnored},s.prototype.stamp=function(t){if(t=this._find(t)){this.stamps=this.stamps.concat(t);for(var e=0,i=t.length;i>e;e++){var o=t[e];this.ignore(o)}}},s.prototype.unstamp=function(t){if(t=this._find(t))for(var e=0,i=t.length;i>e;e++){var o=t[e];n.removeFrom(this.stamps,o),this.unignore(o)}},s.prototype._find=function(t){return t?("string"==typeof t&&(t=this.element.querySelectorAll(t)),t=n.makeArray(t)):void 0},s.prototype._manageStamps=function(){if(this.stamps&&this.stamps.length){this._getBoundingRect();for(var t=0,e=this.stamps.length;e>t;t++){var i=this.stamps[t];this._manageStamp(i)}}},s.prototype._getBoundingRect=function(){var t=this.element.getBoundingClientRect(),e=this.size;this._boundingRect={left:t.left+e.paddingLeft+e.borderLeftWidth,top:t.top+e.paddingTop+e.borderTopWidth,right:t.right-(e.paddingRight+e.borderRightWidth),bottom:t.bottom-(e.paddingBottom+e.borderBottomWidth)}},s.prototype._manageStamp=p,s.prototype._getElementOffset=function(t){var e=t.getBoundingClientRect(),i=this._boundingRect,n=o(t),r={left:e.left-i.left-n.marginLeft,top:e.top-i.top-n.marginTop,right:i.right-e.right-n.marginRight,bottom:i.bottom-e.bottom-n.marginBottom};return r},s.prototype.handleEvent=function(t){var e="on"+t.type;this[e]&&this[e](t)},s.prototype.bindResize=function(){this.isResizeBound||(e.bind(t,"resize",this),this.isResizeBound=!0)},s.prototype.unbindResize=function(){this.isResizeBound&&e.unbind(t,"resize",this),this.isResizeBound=!1},s.prototype.onresize=function(){function t(){e.resize(),delete e.resizeTimeout}this.resizeTimeout&&clearTimeout(this.resizeTimeout);var e=this;this.resizeTimeout=setTimeout(t,100)},s.prototype.resize=function(){this.isResizeBound&&this.needsResizeLayout()&&this.layout()},s.prototype.needsResizeLayout=function(){var t=o(this.element),e=this.size&&t;return e&&t.innerWidth!==this.size.innerWidth},s.prototype.addItems=function(t){var e=this._itemize(t);return e.length&&(this.items=this.items.concat(e)),e},s.prototype.appended=function(t){var e=this.addItems(t);e.length&&(this.layoutItems(e,!0),this.reveal(e))},s.prototype.prepended=function(t){var e=this._itemize(t);if(e.length){var i=this.items.slice(0);this.items=e.concat(i),this._resetLayout(),this._manageStamps(),this.layoutItems(e,!0),this.reveal(e),this.layoutItems(i)}},s.prototype.reveal=function(t){this._emitCompleteOnItems("reveal",t);for(var e=t&&t.length,i=0;e&&e>i;i++){var o=t[i];o.reveal()}},s.prototype.hide=function(t){this._emitCompleteOnItems("hide",t);for(var e=t&&t.length,i=0;e&&e>i;i++){var o=t[i];o.hide()}},s.prototype.revealItemElements=function(t){var e=this.getItems(t);this.reveal(e)},s.prototype.hideItemElements=function(t){var e=this.getItems(t);this.hide(e)},s.prototype.getItem=function(t){for(var e=0,i=this.items.length;i>e;e++){var o=this.items[e];if(o.element===t)return o}},s.prototype.getItems=function(t){t=n.makeArray(t);for(var e=[],i=0,o=t.length;o>i;i++){var r=t[i],s=this.getItem(r);s&&e.push(s)}return e},s.prototype.remove=function(t){var e=this.getItems(t);if(this._emitCompleteOnItems("remove",e),e&&e.length)for(var i=0,o=e.length;o>i;i++){var r=e[i];r.remove(),n.removeFrom(this.items,r)}},s.prototype.destroy=function(){var t=this.element.style;t.height="",t.position="",t.width="";for(var e=0,i=this.items.length;i>e;e++){var o=this.items[e];o.destroy()}this.unbindResize();var n=this.element.outlayerGUID;delete f[n],delete this.element.outlayerGUID,u&&u.removeData(this.element,this.constructor.namespace)},s.data=function(t){t=n.getQueryElement(t);var e=t&&t.outlayerGUID;return e&&f[e]},s.create=function(t,e){function i(){s.apply(this,arguments)}return Object.create?i.prototype=Object.create(s.prototype):n.extend(i.prototype,s.prototype),i.prototype.constructor=i,i.defaults=n.extend({},s.defaults),n.extend(i.defaults,e),i.prototype.settings={},i.namespace=t,i.data=s.data,i.Item=function(){r.apply(this,arguments)},i.Item.prototype=new r,n.htmlInit(i,t),u&&u.bridget&&u.bridget(t,i),i},s.Item=r,s}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/item",["outlayer/outlayer"],e):"object"==typeof exports?module.exports=e(require("outlayer")):(t.Isotope=t.Isotope||{},t.Isotope.Item=e(t.Outlayer))}(window,function(t){function e(){t.Item.apply(this,arguments)}e.prototype=new t.Item,e.prototype._create=function(){this.id=this.layout.itemGUID++,t.Item.prototype._create.call(this),this.sortData={}},e.prototype.updateSortData=function(){if(!this.isIgnored){this.sortData.id=this.id,this.sortData["original-order"]=this.id,this.sortData.random=Math.random();var t=this.layout.options.getSortData,e=this.layout._sorters;for(var i in t){var o=e[i];this.sortData[i]=o(this.element,this)}}};var i=e.prototype.destroy;return e.prototype.destroy=function(){i.apply(this,arguments),this.css({display:""})},e}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-mode",["get-size/get-size","outlayer/outlayer"],e):"object"==typeof exports?module.exports=e(require("get-size"),require("outlayer")):(t.Isotope=t.Isotope||{},t.Isotope.LayoutMode=e(t.getSize,t.Outlayer))}(window,function(t,e){function i(t){this.isotope=t,t&&(this.options=t.options[this.namespace],this.element=t.element,this.items=t.filteredItems,this.size=t.size)}return function(){function t(t){return function(){return e.prototype[t].apply(this.isotope,arguments)}}for(var o=["_resetLayout","_getItemLayoutPosition","_manageStamp","_getContainerSize","_getElementOffset","needsResizeLayout"],n=0,r=o.length;r>n;n++){var s=o[n];i.prototype[s]=t(s)}}(),i.prototype.needsVerticalResizeLayout=function(){var e=t(this.isotope.element),i=this.isotope.size&&e;return i&&e.innerHeight!=this.isotope.size.innerHeight},i.prototype._getMeasurement=function(){this.isotope._getMeasurement.apply(this,arguments)},i.prototype.getColumnWidth=function(){this.getSegmentSize("column","Width")},i.prototype.getRowHeight=function(){this.getSegmentSize("row","Height")},i.prototype.getSegmentSize=function(t,e){var i=t+e,o="outer"+e;if(this._getMeasurement(i,o),!this[i]){var n=this.getFirstItemSize();this[i]=n&&n[o]||this.isotope.size["inner"+e]}},i.prototype.getFirstItemSize=function(){var e=this.isotope.filteredItems[0];return e&&e.element&&t(e.element)},i.prototype.layout=function(){this.isotope.layout.apply(this.isotope,arguments)},i.prototype.getSize=function(){this.isotope.getSize(),this.size=this.isotope.size},i.modes={},i.create=function(t,e){function o(){i.apply(this,arguments)}return o.prototype=new i,e&&(o.options=e),o.prototype.namespace=t,i.modes[t]=o,o},i}),function(t,e){"function"==typeof define&&define.amd?define("masonry/masonry",["outlayer/outlayer","get-size/get-size","fizzy-ui-utils/utils"],e):"object"==typeof exports?module.exports=e(require("outlayer"),require("get-size"),require("fizzy-ui-utils")):t.Masonry=e(t.Outlayer,t.getSize,t.fizzyUIUtils)}(window,function(t,e,i){var o=t.create("masonry");return o.prototype._resetLayout=function(){this.getSize(),this._getMeasurement("columnWidth","outerWidth"),this._getMeasurement("gutter","outerWidth"),this.measureColumns();var t=this.cols;for(this.colYs=[];t--;)this.colYs.push(0);this.maxY=0},o.prototype.measureColumns=function(){if(this.getContainerWidth(),!this.columnWidth){var t=this.items[0],i=t&&t.element;this.columnWidth=i&&e(i).outerWidth||this.containerWidth}var o=this.columnWidth+=this.gutter,n=this.containerWidth+this.gutter,r=n/o,s=o-n%o,a=s&&1>s?"round":"floor";r=Math[a](r),this.cols=Math.max(r,1)},o.prototype.getContainerWidth=function(){var t=this.options.isFitWidth?this.element.parentNode:this.element,i=e(t);this.containerWidth=i&&i.innerWidth},o.prototype._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth%this.columnWidth,o=e&&1>e?"round":"ceil",n=Math[o](t.size.outerWidth/this.columnWidth);n=Math.min(n,this.cols);for(var r=this._getColGroup(n),s=Math.min.apply(Math,r),a=i.indexOf(r,s),u={x:this.columnWidth*a,y:s},p=s+t.size.outerHeight,h=this.cols+1-r.length,f=0;h>f;f++)this.colYs[a+f]=p;return u},o.prototype._getColGroup=function(t){if(2>t)return this.colYs;for(var e=[],i=this.cols+1-t,o=0;i>o;o++){var n=this.colYs.slice(o,o+t);e[o]=Math.max.apply(Math,n)}return e},o.prototype._manageStamp=function(t){var i=e(t),o=this._getElementOffset(t),n=this.options.isOriginLeft?o.left:o.right,r=n+i.outerWidth,s=Math.floor(n/this.columnWidth);s=Math.max(0,s);var a=Math.floor(r/this.columnWidth);a-=r%this.columnWidth?0:1,a=Math.min(this.cols-1,a);for(var u=(this.options.isOriginTop?o.top:o.bottom)+i.outerHeight,p=s;a>=p;p++)this.colYs[p]=Math.max(u,this.colYs[p])},o.prototype._getContainerSize=function(){this.maxY=Math.max.apply(Math,this.colYs);var t={height:this.maxY};return this.options.isFitWidth&&(t.width=this._getContainerFitWidth()),t},o.prototype._getContainerFitWidth=function(){for(var t=0,e=this.cols;--e&&0===this.colYs[e];)t++;return(this.cols-t)*this.columnWidth-this.gutter},o.prototype.needsResizeLayout=function(){var t=this.containerWidth;return this.getContainerWidth(),t!==this.containerWidth},o}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-modes/masonry",["../layout-mode","masonry/masonry"],e):"object"==typeof exports?module.exports=e(require("../layout-mode"),require("masonry-layout")):e(t.Isotope.LayoutMode,t.Masonry)}(window,function(t,e){function i(t,e){for(var i in e)t[i]=e[i];return t}var o=t.create("masonry"),n=o.prototype._getElementOffset,r=o.prototype.layout,s=o.prototype._getMeasurement;i(o.prototype,e.prototype),o.prototype._getElementOffset=n,o.prototype.layout=r,o.prototype._getMeasurement=s;var a=o.prototype.measureColumns;o.prototype.measureColumns=function(){this.items=this.isotope.filteredItems,a.call(this)};var u=o.prototype._manageStamp;return o.prototype._manageStamp=function(){this.options.isOriginLeft=this.isotope.options.isOriginLeft,this.options.isOriginTop=this.isotope.options.isOriginTop,u.apply(this,arguments)},o}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-modes/fit-rows",["../layout-mode"],e):"object"==typeof exports?module.exports=e(require("../layout-mode")):e(t.Isotope.LayoutMode)}(window,function(t){var e=t.create("fitRows");return e.prototype._resetLayout=function(){this.x=0,this.y=0,this.maxY=0,this._getMeasurement("gutter","outerWidth")
},e.prototype._getItemLayoutPosition=function(t){t.getSize();var e=t.size.outerWidth+this.gutter,i=this.isotope.size.innerWidth+this.gutter;0!==this.x&&e+this.x>i&&(this.x=0,this.y=this.maxY);var o={x:this.x,y:this.y};return this.maxY=Math.max(this.maxY,this.y+t.size.outerHeight),this.x+=e,o},e.prototype._getContainerSize=function(){return{height:this.maxY}},e}),function(t,e){"function"==typeof define&&define.amd?define("isotope/js/layout-modes/vertical",["../layout-mode"],e):"object"==typeof exports?module.exports=e(require("../layout-mode")):e(t.Isotope.LayoutMode)}(window,function(t){var e=t.create("vertical",{horizontalAlignment:0});return e.prototype._resetLayout=function(){this.y=0},e.prototype._getItemLayoutPosition=function(t){t.getSize();var e=(this.isotope.size.innerWidth-t.size.outerWidth)*this.options.horizontalAlignment,i=this.y;return this.y+=t.size.outerHeight,{x:e,y:i}},e.prototype._getContainerSize=function(){return{height:this.y}},e}),function(t,e){"function"==typeof define&&define.amd?define(["outlayer/outlayer","get-size/get-size","matches-selector/matches-selector","fizzy-ui-utils/utils","isotope/js/item","isotope/js/layout-mode","isotope/js/layout-modes/masonry","isotope/js/layout-modes/fit-rows","isotope/js/layout-modes/vertical"],function(i,o,n,r,s,a){return e(t,i,o,n,r,s,a)}):"object"==typeof exports?module.exports=e(t,require("outlayer"),require("get-size"),require("desandro-matches-selector"),require("fizzy-ui-utils"),require("./item"),require("./layout-mode"),require("./layout-modes/masonry"),require("./layout-modes/fit-rows"),require("./layout-modes/vertical")):t.Isotope=e(t,t.Outlayer,t.getSize,t.matchesSelector,t.fizzyUIUtils,t.Isotope.Item,t.Isotope.LayoutMode)}(window,function(t,e,i,o,n,r,s){function a(t,e){return function(i,o){for(var n=0,r=t.length;r>n;n++){var s=t[n],a=i.sortData[s],u=o.sortData[s];if(a>u||u>a){var p=void 0!==e[s]?e[s]:e,h=p?1:-1;return(a>u?1:-1)*h}}return 0}}var u=t.jQuery,p=String.prototype.trim?function(t){return t.trim()}:function(t){return t.replace(/^\s+|\s+$/g,"")},h=document.documentElement,f=h.textContent?function(t){return t.textContent}:function(t){return t.innerText},d=e.create("isotope",{layoutMode:"masonry",isJQueryFiltering:!0,sortAscending:!0});d.Item=r,d.LayoutMode=s,d.prototype._create=function(){this.itemGUID=0,this._sorters={},this._getSorters(),e.prototype._create.call(this),this.modes={},this.filteredItems=this.items,this.sortHistory=["original-order"];for(var t in s.modes)this._initLayoutMode(t)},d.prototype.reloadItems=function(){this.itemGUID=0,e.prototype.reloadItems.call(this)},d.prototype._itemize=function(){for(var t=e.prototype._itemize.apply(this,arguments),i=0,o=t.length;o>i;i++){var n=t[i];n.id=this.itemGUID++}return this._updateItemsSortData(t),t},d.prototype._initLayoutMode=function(t){var e=s.modes[t],i=this.options[t]||{};this.options[t]=e.options?n.extend(e.options,i):i,this.modes[t]=new e(this)},d.prototype.layout=function(){return!this._isLayoutInited&&this.options.isInitLayout?(this.arrange(),void 0):(this._layout(),void 0)},d.prototype._layout=function(){var t=this._getIsInstant();this._resetLayout(),this._manageStamps(),this.layoutItems(this.filteredItems,t),this._isLayoutInited=!0},d.prototype.arrange=function(t){function e(){o.reveal(i.needReveal),o.hide(i.needHide)}this.option(t),this._getIsInstant();var i=this._filter(this.items);this.filteredItems=i.matches;var o=this;this._bindArrangeComplete(),this._isInstant?this._noTransition(e):e(),this._sort(),this._layout()},d.prototype._init=d.prototype.arrange,d.prototype._getIsInstant=function(){var t=void 0!==this.options.isLayoutInstant?this.options.isLayoutInstant:!this._isLayoutInited;return this._isInstant=t,t},d.prototype._bindArrangeComplete=function(){function t(){e&&i&&o&&n.emitEvent("arrangeComplete",[n.filteredItems])}var e,i,o,n=this;this.once("layoutComplete",function(){e=!0,t()}),this.once("hideComplete",function(){i=!0,t()}),this.once("revealComplete",function(){o=!0,t()})},d.prototype._filter=function(t){var e=this.options.filter;e=e||"*";for(var i=[],o=[],n=[],r=this._getFilterTest(e),s=0,a=t.length;a>s;s++){var u=t[s];if(!u.isIgnored){var p=r(u);p&&i.push(u),p&&u.isHidden?o.push(u):p||u.isHidden||n.push(u)}}return{matches:i,needReveal:o,needHide:n}},d.prototype._getFilterTest=function(t){return u&&this.options.isJQueryFiltering?function(e){return u(e.element).is(t)}:"function"==typeof t?function(e){return t(e.element)}:function(e){return o(e.element,t)}},d.prototype.updateSortData=function(t){var e;t?(t=n.makeArray(t),e=this.getItems(t)):e=this.items,this._getSorters(),this._updateItemsSortData(e)},d.prototype._getSorters=function(){var t=this.options.getSortData;for(var e in t){var i=t[e];this._sorters[e]=l(i)}},d.prototype._updateItemsSortData=function(t){for(var e=t&&t.length,i=0;e&&e>i;i++){var o=t[i];o.updateSortData()}};var l=function(){function t(t){if("string"!=typeof t)return t;var i=p(t).split(" "),o=i[0],n=o.match(/^\[(.+)\]$/),r=n&&n[1],s=e(r,o),a=d.sortDataParsers[i[1]];return t=a?function(t){return t&&a(s(t))}:function(t){return t&&s(t)}}function e(t,e){var i;return i=t?function(e){return e.getAttribute(t)}:function(t){var i=t.querySelector(e);return i&&f(i)}}return t}();d.sortDataParsers={parseInt:function(t){return parseInt(t,10)},parseFloat:function(t){return parseFloat(t)}},d.prototype._sort=function(){var t=this.options.sortBy;if(t){var e=[].concat.apply(t,this.sortHistory),i=a(e,this.options.sortAscending);this.filteredItems.sort(i),t!=this.sortHistory[0]&&this.sortHistory.unshift(t)}},d.prototype._mode=function(){var t=this.options.layoutMode,e=this.modes[t];if(!e)throw Error("No layout mode: "+t);return e.options=this.options[t],e},d.prototype._resetLayout=function(){e.prototype._resetLayout.call(this),this._mode()._resetLayout()},d.prototype._getItemLayoutPosition=function(t){return this._mode()._getItemLayoutPosition(t)},d.prototype._manageStamp=function(t){this._mode()._manageStamp(t)},d.prototype._getContainerSize=function(){return this._mode()._getContainerSize()},d.prototype.needsResizeLayout=function(){return this._mode().needsResizeLayout()},d.prototype.appended=function(t){var e=this.addItems(t);if(e.length){var i=this._filterRevealAdded(e);this.filteredItems=this.filteredItems.concat(i)}},d.prototype.prepended=function(t){var e=this._itemize(t);if(e.length){this._resetLayout(),this._manageStamps();var i=this._filterRevealAdded(e);this.layoutItems(this.filteredItems),this.filteredItems=i.concat(this.filteredItems),this.items=e.concat(this.items)}},d.prototype._filterRevealAdded=function(t){var e=this._filter(t);return this.hide(e.needHide),this.reveal(e.matches),this.layoutItems(e.matches,!0),e.matches},d.prototype.insert=function(t){var e=this.addItems(t);if(e.length){var i,o,n=e.length;for(i=0;n>i;i++)o=e[i],this.element.appendChild(o.element);var r=this._filter(e).matches;for(i=0;n>i;i++)e[i].isLayoutInstant=!0;for(this.arrange(),i=0;n>i;i++)delete e[i].isLayoutInstant;this.reveal(r)}};var c=d.prototype.remove;return d.prototype.remove=function(t){t=n.makeArray(t);var e=this.getItems(t);c.call(this,t);var i=e&&e.length;if(i)for(var o=0;i>o;o++){var r=e[o];n.removeFrom(this.filteredItems,r)}},d.prototype.shuffle=function(){for(var t=0,e=this.items.length;e>t;t++){var i=this.items[t];i.sortData.random=Math.random()}this.options.sortBy="random",this._sort(),this._layout()},d.prototype._noTransition=function(t){var e=this.options.transitionDuration;this.options.transitionDuration=0;var i=t.call(this);return this.options.transitionDuration=e,i},d.prototype.getFilteredItemElements=function(){for(var t=[],e=0,i=this.filteredItems.length;i>e;e++)t.push(this.filteredItems[e].element);return t},d});



/*-------------------------------------------------------------
  05. MeanMenu jquery Menu Plugin / Mobile Menu
---------------------------------------------------------------*/


/*!
* jQuery meanMenu v2.0.8
* @Copyright (C) 2012-2014 Chris Wharton @ MeanThemes (https://github.com/meanthemes/meanMenu)
*
*/
/*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT
* HOLDERS MAKE NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED,
* INCLUDING BUT NOT LIMITED TO, WARRANTIES OF MERCHANTABILITY OR
* FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE
* OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS,
* COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.COPYRIGHT HOLDERS WILL NOT
* BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL OR CONSEQUENTIAL
* DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE OR DOCUMENTATION.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://gnu.org/licenses/>.
*
* Find more information at http://www.meanthemes.com/plugins/meanmenu/
*
*/
(function ($) {
    "use strict";
        $.fn.meanmenu = function (options) {
                var defaults = {
                        meanMenuTarget: jQuery(this), // Target the current HTML markup you wish to replace
                        meanMenuContainer: '.mobile-menu-area .container', // Choose where meanmenu will be placed within the HTML
                        meanMenuClose: "X", // single character you want to represent the close menu button
                        meanMenuCloseSize: "18px", // set font size of close button
                        meanMenuOpen: "<span /><span /><span />", // text/markup you want when menu is closed
                        meanRevealPosition: "right", // left right or center positions
                        meanRevealPositionDistance: "0", // Tweak the position of the menu
                        meanRevealColour: "", // override CSS colours for the reveal background
                        meanScreenWidth: "767", // set the screen width you want meanmenu to kick in at
                        meanNavPush: "", // set a height here in px, em or % if you want to budge your layout now the navigation is missing.
                        meanShowChildren: true, // true to show children in the menu, false to hide them
                        meanExpandableChildren: true, // true to allow expand/collapse children
                        meanExpand: "+", // single character you want to represent the expand for ULs
                        meanContract: "-", // single character you want to represent the contract for ULs
                        meanRemoveAttrs: false, // true to remove classes and IDs, false to keep them
                        onePage: false, // set to true for one page sites
                        meanDisplay: "block", // override display method for table cell based layouts e.g. table-cell
                        removeElements: "" // set to hide page elements
                };
                options = $.extend(defaults, options);

                // get browser width
                var currentWidth = window.innerWidth || document.documentElement.clientWidth;

                return this.each(function () {
                        var meanMenu = options.meanMenuTarget;
                        var meanContainer = options.meanMenuContainer;
                        var meanMenuClose = options.meanMenuClose;
                        var meanMenuCloseSize = options.meanMenuCloseSize;
                        var meanMenuOpen = options.meanMenuOpen;
                        var meanRevealPosition = options.meanRevealPosition;
                        var meanRevealPositionDistance = options.meanRevealPositionDistance;
                        var meanRevealColour = options.meanRevealColour;
                        var meanScreenWidth = options.meanScreenWidth;
                        var meanNavPush = options.meanNavPush;
                        var meanRevealClass = ".meanmenu-reveal";
                        var meanShowChildren = options.meanShowChildren;
                        var meanExpandableChildren = options.meanExpandableChildren;
                        var meanExpand = options.meanExpand;
                        var meanContract = options.meanContract;
                        var meanRemoveAttrs = options.meanRemoveAttrs;
                        var onePage = options.onePage;
                        var meanDisplay = options.meanDisplay;
                        var removeElements = options.removeElements;

                        //detect known mobile/tablet usage
                        var isMobile = false;
                        if ( (navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i)) || (navigator.userAgent.match(/iPad/i)) || (navigator.userAgent.match(/Android/i)) || (navigator.userAgent.match(/Blackberry/i)) || (navigator.userAgent.match(/Windows Phone/i)) ) {
                                isMobile = true;
                        }

                        if ( (navigator.userAgent.match(/MSIE 8/i)) || (navigator.userAgent.match(/MSIE 7/i)) ) {
                            // add scrollbar for IE7 & 8 to stop breaking resize function on small content sites
                                jQuery('html').css("overflow-y" , "scroll");
                        }

                        var meanRevealPos = "";
                        var meanCentered = function() {
                            if (meanRevealPosition === "center") {
                                var newWidth = window.innerWidth || document.documentElement.clientWidth;
                                var meanCenter = ( (newWidth/2)-22 )+"px";
                                meanRevealPos = "left:" + meanCenter + ";right:auto;";

                                if (!isMobile) {
                                    jQuery('.meanmenu-reveal').css("left",meanCenter);
                                } else {
                                    jQuery('.meanmenu-reveal').animate({
                                            left: meanCenter
                                    });
                                }
                            }
                        };

                        var menuOn = false;
                        var meanMenuExist = false;


                        if (meanRevealPosition === "right") {
                                meanRevealPos = "right:" + meanRevealPositionDistance + ";left:auto;";
                        }
                        if (meanRevealPosition === "left") {
                                meanRevealPos = "left:" + meanRevealPositionDistance + ";right:auto;";
                        }
                        // run center function
                        meanCentered();

                        // set all styles for mean-reveal
                        var $navreveal = "";

                        var meanInner = function() {
                                // get last class name
                                if (jQuery($navreveal).is(".meanmenu-reveal.meanclose")) {
                                        $navreveal.html(meanMenuClose);
                                } else {
                                        $navreveal.html(meanMenuOpen);
                                }
                        };

                        // re-instate original nav (and call this on window.width functions)
                        var meanOriginal = function() {
                            jQuery('.mean-bar,.mean-push').remove();
                            jQuery(meanContainer).removeClass("mean-container");
                            jQuery(meanMenu).css('display', meanDisplay);
                            menuOn = false;
                            meanMenuExist = false;
                            jQuery(removeElements).removeClass('mean-remove');
                        };

                        // navigation reveal
                        var showMeanMenu = function() {
                                var meanStyles = "background:"+meanRevealColour+";color:"+meanRevealColour+";"+meanRevealPos;
                                if (currentWidth <= meanScreenWidth) {
                                jQuery(removeElements).addClass('mean-remove');
                                    meanMenuExist = true;
                                    // add class to body so we don't need to worry about media queries here, all CSS is wrapped in '.mean-container'
                                    jQuery(meanContainer).addClass("mean-container");
                                    jQuery('.mean-container').prepend('<div class="mean-bar"><a href="#nav" class="meanmenu-reveal" style="'+meanStyles+'">Show Navigation</a><nav class="mean-nav"></nav></div>');

                                    //push meanMenu navigation into .mean-nav
                                    var meanMenuContents = jQuery(meanMenu).html();
                                    jQuery('.mean-nav').html(meanMenuContents);

                                    // remove all classes from EVERYTHING inside meanmenu nav
                                    if(meanRemoveAttrs) {
                                        jQuery('nav.mean-nav ul, nav.mean-nav ul *').each(function() {
                                            // First check if this has mean-remove class
                                            if (jQuery(this).is('.mean-remove')) {
                                                jQuery(this).attr('class', 'mean-remove');
                                            } else {
                                                jQuery(this).removeAttr("class");
                                            }
                                            jQuery(this).removeAttr("id");
                                        });
                                    }

                                    // push in a holder div (this can be used if removal of nav is causing layout issues)
                                    jQuery(meanMenu).before('<div class="mean-push" />');
                                    jQuery('.mean-push').css("margin-top",meanNavPush);

                                    // hide current navigation and reveal mean nav link
                                    jQuery(meanMenu).hide();
                                    jQuery(".meanmenu-reveal").show();

                                    // turn 'X' on or off
                                    jQuery(meanRevealClass).html(meanMenuOpen);
                                    $navreveal = jQuery(meanRevealClass);

                                    //hide mean-nav ul
                                    jQuery('.mean-nav ul').hide();

                                    // hide sub nav
                                    if(meanShowChildren) {
                                            // allow expandable sub nav(s)
                                            if(meanExpandableChildren){
                                                jQuery('.mean-nav ul ul').each(function() {
                                                        if(jQuery(this).children().length){
                                                                jQuery(this,'li:first').parent().append('<a class="mean-expand" href="#" style="font-size: '+ meanMenuCloseSize +'">'+ meanExpand +'</a>');
                                                        }
                                                });
                                                jQuery('.mean-expand').on("click",function(e){
                                                        e.preventDefault();
                                                            if (jQuery(this).hasClass("mean-clicked")) {
                                                                    jQuery(this).text(meanExpand);
                                                                jQuery(this).prev('ul').slideUp(300, function(){});
                                                        } else {
                                                                jQuery(this).text(meanContract);
                                                                jQuery(this).prev('ul').slideDown(300, function(){});
                                                        }
                                                        jQuery(this).toggleClass("mean-clicked");
                                                });
                                            } else {
                                                    jQuery('.mean-nav ul ul').show();
                                            }
                                    } else {
                                            jQuery('.mean-nav ul ul').hide();
                                    }

                                    // add last class to tidy up borders
                                    jQuery('.mean-nav ul li').last().addClass('mean-last');
                                    $navreveal.removeClass("meanclose");
                                    jQuery($navreveal).click(function(e){
                                        e.preventDefault();
                                if( menuOn === false ) {
                                                $navreveal.css("text-align", "center");
                                                $navreveal.css("text-indent", "0");
                                                $navreveal.css("font-size", meanMenuCloseSize);
                                                jQuery('.mean-nav ul:first').slideDown();
                                                menuOn = true;
                                        } else {
                                            jQuery('.mean-nav ul:first').slideUp();
                                            menuOn = false;
                                        }
                                            $navreveal.toggleClass("meanclose");
                                            meanInner();
                                            jQuery(removeElements).addClass('mean-remove');
                                    });

                                    // for one page websites, reset all variables...
                                    if ( onePage ) {
                                        jQuery('.mean-nav ul > li > a:first-child').on( "click" , function () {
                                            jQuery('.mean-nav ul:first').slideUp();
                                            menuOn = false;
                                            jQuery($navreveal).toggleClass("meanclose").html(meanMenuOpen);
                                        });
                                    }
                            } else {
                                meanOriginal();
                            }
                        };

                        if (!isMobile) {
                                // reset menu on resize above meanScreenWidth
                                jQuery(window).resize(function () {
                                        currentWidth = window.innerWidth || document.documentElement.clientWidth;
                                        if (currentWidth > meanScreenWidth) {
                                                meanOriginal();
                                        } else {
                                            meanOriginal();
                                        }
                                        if (currentWidth <= meanScreenWidth) {
                                                showMeanMenu();
                                                meanCentered();
                                        } else {
                                            meanOriginal();
                                        }
                                });
                        }

                    jQuery(window).resize(function () {
                                // get browser width
                                currentWidth = window.innerWidth || document.documentElement.clientWidth;

                                if (!isMobile) {
                                        meanOriginal();
                                        if (currentWidth <= meanScreenWidth) {
                                                showMeanMenu();
                                                meanCentered();
                                        }
                                } else {
                                        meanCentered();
                                        if (currentWidth <= meanScreenWidth) {
                                                if (meanMenuExist === false) {
                                                        showMeanMenu();
                                                }
                                        } else {
                                                meanOriginal();
                                        }
                                }
                        });

                    // run main menuMenu function on load
                    showMeanMenu();
                });
        };
})(jQuery);






/*! jQuery UI - v1.12.1 - 2017-02-06
* http://jqueryui.com
* Includes: widget.js, keycode.js, unique-id.js, widgets/accordion.js
* Copyright jQuery Foundation and other contributors; Licensed MIT */

(function(t){"function"==typeof define&&define.amd?define(["jquery"],t):t(jQuery)})(function(t){t.ui=t.ui||{},t.ui.version="1.12.1";var e=0,i=Array.prototype.slice;t.cleanData=function(e){return function(i){var s,n,o;for(o=0;null!=(n=i[o]);o++)try{s=t._data(n,"events"),s&&s.remove&&t(n).triggerHandler("remove")}catch(a){}e(i)}}(t.cleanData),t.widget=function(e,i,s){var n,o,a,r={},l=e.split(".")[0];e=e.split(".")[1];var h=l+"-"+e;return s||(s=i,i=t.Widget),t.isArray(s)&&(s=t.extend.apply(null,[{}].concat(s))),t.expr[":"][h.toLowerCase()]=function(e){return!!t.data(e,h)},t[l]=t[l]||{},n=t[l][e],o=t[l][e]=function(t,e){return this._createWidget?(arguments.length&&this._createWidget(t,e),void 0):new o(t,e)},t.extend(o,n,{version:s.version,_proto:t.extend({},s),_childConstructors:[]}),a=new i,a.options=t.widget.extend({},a.options),t.each(s,function(e,s){return t.isFunction(s)?(r[e]=function(){function t(){return i.prototype[e].apply(this,arguments)}function n(t){return i.prototype[e].apply(this,t)}return function(){var e,i=this._super,o=this._superApply;return this._super=t,this._superApply=n,e=s.apply(this,arguments),this._super=i,this._superApply=o,e}}(),void 0):(r[e]=s,void 0)}),o.prototype=t.widget.extend(a,{widgetEventPrefix:n?a.widgetEventPrefix||e:e},r,{constructor:o,namespace:l,widgetName:e,widgetFullName:h}),n?(t.each(n._childConstructors,function(e,i){var s=i.prototype;t.widget(s.namespace+"."+s.widgetName,o,i._proto)}),delete n._childConstructors):i._childConstructors.push(o),t.widget.bridge(e,o),o},t.widget.extend=function(e){for(var s,n,o=i.call(arguments,1),a=0,r=o.length;r>a;a++)for(s in o[a])n=o[a][s],o[a].hasOwnProperty(s)&&void 0!==n&&(e[s]=t.isPlainObject(n)?t.isPlainObject(e[s])?t.widget.extend({},e[s],n):t.widget.extend({},n):n);return e},t.widget.bridge=function(e,s){var n=s.prototype.widgetFullName||e;t.fn[e]=function(o){var a="string"==typeof o,r=i.call(arguments,1),l=this;return a?this.length||"instance"!==o?this.each(function(){var i,s=t.data(this,n);return"instance"===o?(l=s,!1):s?t.isFunction(s[o])&&"_"!==o.charAt(0)?(i=s[o].apply(s,r),i!==s&&void 0!==i?(l=i&&i.jquery?l.pushStack(i.get()):i,!1):void 0):t.error("no such method '"+o+"' for "+e+" widget instance"):t.error("cannot call methods on "+e+" prior to initialization; "+"attempted to call method '"+o+"'")}):l=void 0:(r.length&&(o=t.widget.extend.apply(null,[o].concat(r))),this.each(function(){var e=t.data(this,n);e?(e.option(o||{}),e._init&&e._init()):t.data(this,n,new s(o,this))})),l}},t.Widget=function(){},t.Widget._childConstructors=[],t.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{classes:{},disabled:!1,create:null},_createWidget:function(i,s){s=t(s||this.defaultElement||this)[0],this.element=t(s),this.uuid=e++,this.eventNamespace="."+this.widgetName+this.uuid,this.bindings=t(),this.hoverable=t(),this.focusable=t(),this.classesElementLookup={},s!==this&&(t.data(s,this.widgetFullName,this),this._on(!0,this.element,{remove:function(t){t.target===s&&this.destroy()}}),this.document=t(s.style?s.ownerDocument:s.document||s),this.window=t(this.document[0].defaultView||this.document[0].parentWindow)),this.options=t.widget.extend({},this.options,this._getCreateOptions(),i),this._create(),this.options.disabled&&this._setOptionDisabled(this.options.disabled),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:function(){return{}},_getCreateEventData:t.noop,_create:t.noop,_init:t.noop,destroy:function(){var e=this;this._destroy(),t.each(this.classesElementLookup,function(t,i){e._removeClass(i,t)}),this.element.off(this.eventNamespace).removeData(this.widgetFullName),this.widget().off(this.eventNamespace).removeAttr("aria-disabled"),this.bindings.off(this.eventNamespace)},_destroy:t.noop,widget:function(){return this.element},option:function(e,i){var s,n,o,a=e;if(0===arguments.length)return t.widget.extend({},this.options);if("string"==typeof e)if(a={},s=e.split("."),e=s.shift(),s.length){for(n=a[e]=t.widget.extend({},this.options[e]),o=0;s.length-1>o;o++)n[s[o]]=n[s[o]]||{},n=n[s[o]];if(e=s.pop(),1===arguments.length)return void 0===n[e]?null:n[e];n[e]=i}else{if(1===arguments.length)return void 0===this.options[e]?null:this.options[e];a[e]=i}return this._setOptions(a),this},_setOptions:function(t){var e;for(e in t)this._setOption(e,t[e]);return this},_setOption:function(t,e){return"classes"===t&&this._setOptionClasses(e),this.options[t]=e,"disabled"===t&&this._setOptionDisabled(e),this},_setOptionClasses:function(e){var i,s,n;for(i in e)n=this.classesElementLookup[i],e[i]!==this.options.classes[i]&&n&&n.length&&(s=t(n.get()),this._removeClass(n,i),s.addClass(this._classes({element:s,keys:i,classes:e,add:!0})))},_setOptionDisabled:function(t){this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!!t),t&&(this._removeClass(this.hoverable,null,"ui-state-hover"),this._removeClass(this.focusable,null,"ui-state-focus"))},enable:function(){return this._setOptions({disabled:!1})},disable:function(){return this._setOptions({disabled:!0})},_classes:function(e){function i(i,o){var a,r;for(r=0;i.length>r;r++)a=n.classesElementLookup[i[r]]||t(),a=e.add?t(t.unique(a.get().concat(e.element.get()))):t(a.not(e.element).get()),n.classesElementLookup[i[r]]=a,s.push(i[r]),o&&e.classes[i[r]]&&s.push(e.classes[i[r]])}var s=[],n=this;return e=t.extend({element:this.element,classes:this.options.classes||{}},e),this._on(e.element,{remove:"_untrackClassesElement"}),e.keys&&i(e.keys.match(/\S+/g)||[],!0),e.extra&&i(e.extra.match(/\S+/g)||[]),s.join(" ")},_untrackClassesElement:function(e){var i=this;t.each(i.classesElementLookup,function(s,n){-1!==t.inArray(e.target,n)&&(i.classesElementLookup[s]=t(n.not(e.target).get()))})},_removeClass:function(t,e,i){return this._toggleClass(t,e,i,!1)},_addClass:function(t,e,i){return this._toggleClass(t,e,i,!0)},_toggleClass:function(t,e,i,s){s="boolean"==typeof s?s:i;var n="string"==typeof t||null===t,o={extra:n?e:i,keys:n?t:e,element:n?this.element:t,add:s};return o.element.toggleClass(this._classes(o),s),this},_on:function(e,i,s){var n,o=this;"boolean"!=typeof e&&(s=i,i=e,e=!1),s?(i=n=t(i),this.bindings=this.bindings.add(i)):(s=i,i=this.element,n=this.widget()),t.each(s,function(s,a){function r(){return e||o.options.disabled!==!0&&!t(this).hasClass("ui-state-disabled")?("string"==typeof a?o[a]:a).apply(o,arguments):void 0}"string"!=typeof a&&(r.guid=a.guid=a.guid||r.guid||t.guid++);var l=s.match(/^([\w:-]*)\s*(.*)$/),h=l[1]+o.eventNamespace,c=l[2];c?n.on(h,c,r):i.on(h,r)})},_off:function(e,i){i=(i||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,e.off(i).off(i),this.bindings=t(this.bindings.not(e).get()),this.focusable=t(this.focusable.not(e).get()),this.hoverable=t(this.hoverable.not(e).get())},_delay:function(t,e){function i(){return("string"==typeof t?s[t]:t).apply(s,arguments)}var s=this;return setTimeout(i,e||0)},_hoverable:function(e){this.hoverable=this.hoverable.add(e),this._on(e,{mouseenter:function(e){this._addClass(t(e.currentTarget),null,"ui-state-hover")},mouseleave:function(e){this._removeClass(t(e.currentTarget),null,"ui-state-hover")}})},_focusable:function(e){this.focusable=this.focusable.add(e),this._on(e,{focusin:function(e){this._addClass(t(e.currentTarget),null,"ui-state-focus")},focusout:function(e){this._removeClass(t(e.currentTarget),null,"ui-state-focus")}})},_trigger:function(e,i,s){var n,o,a=this.options[e];if(s=s||{},i=t.Event(i),i.type=(e===this.widgetEventPrefix?e:this.widgetEventPrefix+e).toLowerCase(),i.target=this.element[0],o=i.originalEvent)for(n in o)n in i||(i[n]=o[n]);return this.element.trigger(i,s),!(t.isFunction(a)&&a.apply(this.element[0],[i].concat(s))===!1||i.isDefaultPrevented())}},t.each({show:"fadeIn",hide:"fadeOut"},function(e,i){t.Widget.prototype["_"+e]=function(s,n,o){"string"==typeof n&&(n={effect:n});var a,r=n?n===!0||"number"==typeof n?i:n.effect||i:e;n=n||{},"number"==typeof n&&(n={duration:n}),a=!t.isEmptyObject(n),n.complete=o,n.delay&&s.delay(n.delay),a&&t.effects&&t.effects.effect[r]?s[e](n):r!==e&&s[r]?s[r](n.duration,n.easing,o):s.queue(function(i){t(this)[e](),o&&o.call(s[0]),i()})}}),t.widget,t.ui.keyCode={BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38},t.fn.extend({uniqueId:function(){var t=0;return function(){return this.each(function(){this.id||(this.id="ui-id-"+ ++t)})}}(),removeUniqueId:function(){return this.each(function(){/^ui-id-\d+$/.test(this.id)&&t(this).removeAttr("id")})}}),t.widget("ui.accordion",{version:"1.12.1",options:{active:0,animate:{},classes:{"ui-accordion-header":"ui-corner-top","ui-accordion-header-collapsed":"ui-corner-all","ui-accordion-content":"ui-corner-bottom"},collapsible:!1,event:"click",header:"> li > :first-child, > :not(li):even",heightStyle:"auto",icons:{activeHeader:"ui-icon-triangle-1-s",header:"ui-icon-triangle-1-e"},activate:null,beforeActivate:null},hideProps:{borderTopWidth:"hide",borderBottomWidth:"hide",paddingTop:"hide",paddingBottom:"hide",height:"hide"},showProps:{borderTopWidth:"show",borderBottomWidth:"show",paddingTop:"show",paddingBottom:"show",height:"show"},_create:function(){var e=this.options;this.prevShow=this.prevHide=t(),this._addClass("ui-accordion","ui-widget ui-helper-reset"),this.element.attr("role","tablist"),e.collapsible||e.active!==!1&&null!=e.active||(e.active=0),this._processPanels(),0>e.active&&(e.active+=this.headers.length),this._refresh()},_getCreateEventData:function(){return{header:this.active,panel:this.active.length?this.active.next():t()}},_createIcons:function(){var e,i,s=this.options.icons;s&&(e=t("<span>"),this._addClass(e,"ui-accordion-header-icon","ui-icon "+s.header),e.prependTo(this.headers),i=this.active.children(".ui-accordion-header-icon"),this._removeClass(i,s.header)._addClass(i,null,s.activeHeader)._addClass(this.headers,"ui-accordion-icons"))},_destroyIcons:function(){this._removeClass(this.headers,"ui-accordion-icons"),this.headers.children(".ui-accordion-header-icon").remove()},_destroy:function(){var t;this.element.removeAttr("role"),this.headers.removeAttr("role aria-expanded aria-selected aria-controls tabIndex").removeUniqueId(),this._destroyIcons(),t=this.headers.next().css("display","").removeAttr("role aria-hidden aria-labelledby").removeUniqueId(),"content"!==this.options.heightStyle&&t.css("height","")},_setOption:function(t,e){return"active"===t?(this._activate(e),void 0):("event"===t&&(this.options.event&&this._off(this.headers,this.options.event),this._setupEvents(e)),this._super(t,e),"collapsible"!==t||e||this.options.active!==!1||this._activate(0),"icons"===t&&(this._destroyIcons(),e&&this._createIcons()),void 0)},_setOptionDisabled:function(t){this._super(t),this.element.attr("aria-disabled",t),this._toggleClass(null,"ui-state-disabled",!!t),this._toggleClass(this.headers.add(this.headers.next()),null,"ui-state-disabled",!!t)},_keydown:function(e){if(!e.altKey&&!e.ctrlKey){var i=t.ui.keyCode,s=this.headers.length,n=this.headers.index(e.target),o=!1;switch(e.keyCode){case i.RIGHT:case i.DOWN:o=this.headers[(n+1)%s];break;case i.LEFT:case i.UP:o=this.headers[(n-1+s)%s];break;case i.SPACE:case i.ENTER:this._eventHandler(e);break;case i.HOME:o=this.headers[0];break;case i.END:o=this.headers[s-1]}o&&(t(e.target).attr("tabIndex",-1),t(o).attr("tabIndex",0),t(o).trigger("focus"),e.preventDefault())}},_panelKeyDown:function(e){e.keyCode===t.ui.keyCode.UP&&e.ctrlKey&&t(e.currentTarget).prev().trigger("focus")},refresh:function(){var e=this.options;this._processPanels(),e.active===!1&&e.collapsible===!0||!this.headers.length?(e.active=!1,this.active=t()):e.active===!1?this._activate(0):this.active.length&&!t.contains(this.element[0],this.active[0])?this.headers.length===this.headers.find(".ui-state-disabled").length?(e.active=!1,this.active=t()):this._activate(Math.max(0,e.active-1)):e.active=this.headers.index(this.active),this._destroyIcons(),this._refresh()},_processPanels:function(){var t=this.headers,e=this.panels;this.headers=this.element.find(this.options.header),this._addClass(this.headers,"ui-accordion-header ui-accordion-header-collapsed","ui-state-default"),this.panels=this.headers.next().filter(":not(.ui-accordion-content-active)").hide(),this._addClass(this.panels,"ui-accordion-content","ui-helper-reset ui-widget-content"),e&&(this._off(t.not(this.headers)),this._off(e.not(this.panels)))},_refresh:function(){var e,i=this.options,s=i.heightStyle,n=this.element.parent();this.active=this._findActive(i.active),this._addClass(this.active,"ui-accordion-header-active","ui-state-active")._removeClass(this.active,"ui-accordion-header-collapsed"),this._addClass(this.active.next(),"ui-accordion-content-active"),this.active.next().show(),this.headers.attr("role","tab").each(function(){var e=t(this),i=e.uniqueId().attr("id"),s=e.next(),n=s.uniqueId().attr("id");e.attr("aria-controls",n),s.attr("aria-labelledby",i)}).next().attr("role","tabpanel"),this.headers.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}).next().attr({"aria-hidden":"true"}).hide(),this.active.length?this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}).next().attr({"aria-hidden":"false"}):this.headers.eq(0).attr("tabIndex",0),this._createIcons(),this._setupEvents(i.event),"fill"===s?(e=n.height(),this.element.siblings(":visible").each(function(){var i=t(this),s=i.css("position");"absolute"!==s&&"fixed"!==s&&(e-=i.outerHeight(!0))}),this.headers.each(function(){e-=t(this).outerHeight(!0)}),this.headers.next().each(function(){t(this).height(Math.max(0,e-t(this).innerHeight()+t(this).height()))}).css("overflow","auto")):"auto"===s&&(e=0,this.headers.next().each(function(){var i=t(this).is(":visible");i||t(this).show(),e=Math.max(e,t(this).css("height","").height()),i||t(this).hide()}).height(e))},_activate:function(e){var i=this._findActive(e)[0];i!==this.active[0]&&(i=i||this.active[0],this._eventHandler({target:i,currentTarget:i,preventDefault:t.noop}))},_findActive:function(e){return"number"==typeof e?this.headers.eq(e):t()},_setupEvents:function(e){var i={keydown:"_keydown"};e&&t.each(e.split(" "),function(t,e){i[e]="_eventHandler"}),this._off(this.headers.add(this.headers.next())),this._on(this.headers,i),this._on(this.headers.next(),{keydown:"_panelKeyDown"}),this._hoverable(this.headers),this._focusable(this.headers)},_eventHandler:function(e){var i,s,n=this.options,o=this.active,a=t(e.currentTarget),r=a[0]===o[0],l=r&&n.collapsible,h=l?t():a.next(),c=o.next(),u={oldHeader:o,oldPanel:c,newHeader:l?t():a,newPanel:h};e.preventDefault(),r&&!n.collapsible||this._trigger("beforeActivate",e,u)===!1||(n.active=l?!1:this.headers.index(a),this.active=r?t():a,this._toggle(u),this._removeClass(o,"ui-accordion-header-active","ui-state-active"),n.icons&&(i=o.children(".ui-accordion-header-icon"),this._removeClass(i,null,n.icons.activeHeader)._addClass(i,null,n.icons.header)),r||(this._removeClass(a,"ui-accordion-header-collapsed")._addClass(a,"ui-accordion-header-active","ui-state-active"),n.icons&&(s=a.children(".ui-accordion-header-icon"),this._removeClass(s,null,n.icons.header)._addClass(s,null,n.icons.activeHeader)),this._addClass(a.next(),"ui-accordion-content-active")))},_toggle:function(e){var i=e.newPanel,s=this.prevShow.length?this.prevShow:e.oldPanel;this.prevShow.add(this.prevHide).stop(!0,!0),this.prevShow=i,this.prevHide=s,this.options.animate?this._animate(i,s,e):(s.hide(),i.show(),this._toggleComplete(e)),s.attr({"aria-hidden":"true"}),s.prev().attr({"aria-selected":"false","aria-expanded":"false"}),i.length&&s.length?s.prev().attr({tabIndex:-1,"aria-expanded":"false"}):i.length&&this.headers.filter(function(){return 0===parseInt(t(this).attr("tabIndex"),10)}).attr("tabIndex",-1),i.attr("aria-hidden","false").prev().attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0})},_animate:function(t,e,i){var s,n,o,a=this,r=0,l=t.css("box-sizing"),h=t.length&&(!e.length||t.index()<e.index()),c=this.options.animate||{},u=h&&c.down||c,d=function(){a._toggleComplete(i)};return"number"==typeof u&&(o=u),"string"==typeof u&&(n=u),n=n||u.easing||c.easing,o=o||u.duration||c.duration,e.length?t.length?(s=t.show().outerHeight(),e.animate(this.hideProps,{duration:o,easing:n,step:function(t,e){e.now=Math.round(t)}}),t.hide().animate(this.showProps,{duration:o,easing:n,complete:d,step:function(t,i){i.now=Math.round(t),"height"!==i.prop?"content-box"===l&&(r+=i.now):"content"!==a.options.heightStyle&&(i.now=Math.round(s-e.outerHeight()-r),r=0)}}),void 0):e.animate(this.hideProps,o,n,d):t.animate(this.showProps,o,n,d)},_toggleComplete:function(t){var e=t.oldPanel,i=e.prev();this._removeClass(e,"ui-accordion-content-active"),this._removeClass(i,"ui-accordion-header-active")._addClass(i,"ui-accordion-header-collapsed"),e.length&&(e.parent()[0].className=e.parent()[0].className),this._trigger("activate",null,t)}})});









/*-------------------------------------------------------------
  02. Scrollup jquery 
---------------------------------------------------------------*/

/*!
 * scrollup v2.4.1
 * Url: http://markgoodyear.com/labs/scrollup/
 * Copyright (c) Mark Goodyear — @markgdyr — http://markgoodyear.com
 * License: MIT
 */
!function(l,o,e){"use strict";l.fn.scrollUp=function(o){l.data(e.body,"scrollUp")||(l.data(e.body,"scrollUp",!0),l.fn.scrollUp.init(o))},l.fn.scrollUp.init=function(r){var s,t,c,i,n,a,d,p=l.fn.scrollUp.settings=l.extend({},l.fn.scrollUp.defaults,r),f=!1;switch(d=p.scrollTrigger?l(p.scrollTrigger):l("<a/>",{id:p.scrollName,href:"#top"}),p.scrollTitle&&d.attr("title",p.scrollTitle),d.appendTo("body"),p.scrollImg||p.scrollTrigger||d.html(p.scrollText),d.css({display:"none",position:"fixed",zIndex:p.zIndex}),p.activeOverlay&&l("<div/>",{id:p.scrollName+"-active"}).css({position:"absolute",top:p.scrollDistance+"px",width:"100%",borderTop:"1px dotted"+p.activeOverlay,zIndex:p.zIndex}).appendTo("body"),p.animation){case"fade":s="fadeIn",t="fadeOut",c=p.animationSpeed;break;case"slide":s="slideDown",t="slideUp",c=p.animationSpeed;break;default:s="show",t="hide",c=0}i="top"===p.scrollFrom?p.scrollDistance:l(e).height()-l(o).height()-p.scrollDistance,n=l(o).scroll(function(){l(o).scrollTop()>i?f||(d[s](c),f=!0):f&&(d[t](c),f=!1)}),p.scrollTarget?"number"==typeof p.scrollTarget?a=p.scrollTarget:"string"==typeof p.scrollTarget&&(a=Math.floor(l(p.scrollTarget).offset().top)):a=0,d.click(function(o){o.preventDefault(),l("html, body").animate({scrollTop:a},p.scrollSpeed,p.easingType)})},l.fn.scrollUp.defaults={scrollName:"scrollUp",scrollDistance:300,scrollFrom:"top",scrollSpeed:300,easingType:"linear",animation:"fade",animationSpeed:200,scrollTrigger:!1,scrollTarget:!1,scrollText:"Scroll to top",scrollTitle:!1,scrollImg:!1,activeOverlay:!1,zIndex:2147483647},l.fn.scrollUp.destroy=function(r){l.removeData(e.body,"scrollUp"),l("#"+l.fn.scrollUp.settings.scrollName).remove(),l("#"+l.fn.scrollUp.settings.scrollName+"-active").remove(),l.fn.jquery.split(".")[1]>=7?l(o).off("scroll",r):l(o).unbind("scroll",r)},l.scrollUp=l.fn.scrollUp}(jQuery,window,document);






/*! Magnific Popup - v1.1.0 - 2016-02-20
* http://dimsemenov.com/plugins/magnific-popup/
* Copyright (c) 2016 Dmitry Semenov; */
/*! Magnific Popup - v1.1.0 - 2016-02-20
* http://dimsemenov.com/plugins/magnific-popup/
* Copyright (c) 2016 Dmitry Semenov; */
;(function (factory) { 
if (typeof define === 'function' && define.amd) { 
 // AMD. Register as an anonymous module. 
 define(['jquery'], factory); 
 } else if (typeof exports === 'object') { 
 // Node/CommonJS 
 factory(require('jquery')); 
 } else { 
 // Browser globals 
 factory(window.jQuery || window.Zepto); 
 } 
 }(function($) { 

/*>>core*/
/**
 * 
 * Magnific Popup Core JS file
 * 
 */


/**
 * Private static constants
 */
var CLOSE_EVENT = 'Close',
  BEFORE_CLOSE_EVENT = 'BeforeClose',
  AFTER_CLOSE_EVENT = 'AfterClose',
  BEFORE_APPEND_EVENT = 'BeforeAppend',
  MARKUP_PARSE_EVENT = 'MarkupParse',
  OPEN_EVENT = 'Open',
  CHANGE_EVENT = 'Change',
  NS = 'mfp',
  EVENT_NS = '.' + NS,
  READY_CLASS = 'mfp-ready',
  REMOVING_CLASS = 'mfp-removing',
  PREVENT_CLOSE_CLASS = 'mfp-prevent-close';


/**
 * Private vars 
 */
/*jshint -W079 */
var mfp, // As we have only one instance of MagnificPopup object, we define it locally to not to use 'this'
  MagnificPopup = function(){},
  _isJQ = !!(window.jQuery),
  _prevStatus,
  _window = $(window),
  _document,
  _prevContentType,
  _wrapClasses,
  _currPopupType;


/**
 * Private functions
 */
var _mfpOn = function(name, f) {
    mfp.ev.on(NS + name + EVENT_NS, f);
  },
  _getEl = function(className, appendTo, html, raw) {
    var el = document.createElement('div');
    el.className = 'mfp-'+className;
    if(html) {
      el.innerHTML = html;
    }
    if(!raw) {
      el = $(el);
      if(appendTo) {
        el.appendTo(appendTo);
      }
    } else if(appendTo) {
      appendTo.appendChild(el);
    }
    return el;
  },
  _mfpTrigger = function(e, data) {
    mfp.ev.triggerHandler(NS + e, data);

    if(mfp.st.callbacks) {
      // converts "mfpEventName" to "eventName" callback and triggers it if it's present
      e = e.charAt(0).toLowerCase() + e.slice(1);
      if(mfp.st.callbacks[e]) {
        mfp.st.callbacks[e].apply(mfp, $.isArray(data) ? data : [data]);
      }
    }
  },
  _getCloseBtn = function(type) {
    if(type !== _currPopupType || !mfp.currTemplate.closeBtn) {
      mfp.currTemplate.closeBtn = $( mfp.st.closeMarkup.replace('%title%', mfp.st.tClose ) );
      _currPopupType = type;
    }
    return mfp.currTemplate.closeBtn;
  },
  // Initialize Magnific Popup only when called at least once
  _checkInstance = function() {
    if(!$.magnificPopup.instance) {
      /*jshint -W020 */
      mfp = new MagnificPopup();
      mfp.init();
      $.magnificPopup.instance = mfp;
    }
  },
  // CSS transition detection, http://stackoverflow.com/questions/7264899/detect-css-transitions-using-javascript-and-without-modernizr
  supportsTransitions = function() {
    var s = document.createElement('p').style, // 's' for style. better to create an element if body yet to exist
      v = ['ms','O','Moz','Webkit']; // 'v' for vendor

    if( s['transition'] !== undefined ) {
      return true; 
    }
      
    while( v.length ) {
      if( v.pop() + 'Transition' in s ) {
        return true;
      }
    }
        
    return false;
  };



/**
 * Public functions
 */
MagnificPopup.prototype = {

  constructor: MagnificPopup,

  /**
   * Initializes Magnific Popup plugin. 
   * This function is triggered only once when $.fn.magnificPopup or $.magnificPopup is executed
   */
  init: function() {
    var appVersion = navigator.appVersion;
    mfp.isLowIE = mfp.isIE8 = document.all && !document.addEventListener;
    mfp.isAndroid = (/android/gi).test(appVersion);
    mfp.isIOS = (/iphone|ipad|ipod/gi).test(appVersion);
    mfp.supportsTransition = supportsTransitions();

    // We disable fixed positioned lightbox on devices that don't handle it nicely.
    // If you know a better way of detecting this - let me know.
    mfp.probablyMobile = (mfp.isAndroid || mfp.isIOS || /(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent) );
    _document = $(document);

    mfp.popupsCache = {};
  },

  /**
   * Opens popup
   * @param  data [description]
   */
  open: function(data) {

    var i;

    if(data.isObj === false) { 
      // convert jQuery collection to array to avoid conflicts later
      mfp.items = data.items.toArray();

      mfp.index = 0;
      var items = data.items,
        item;
      for(i = 0; i < items.length; i++) {
        item = items[i];
        if(item.parsed) {
          item = item.el[0];
        }
        if(item === data.el[0]) {
          mfp.index = i;
          break;
        }
      }
    } else {
      mfp.items = $.isArray(data.items) ? data.items : [data.items];
      mfp.index = data.index || 0;
    }

    // if popup is already opened - we just update the content
    if(mfp.isOpen) {
      mfp.updateItemHTML();
      return;
    }
    
    mfp.types = []; 
    _wrapClasses = '';
    if(data.mainEl && data.mainEl.length) {
      mfp.ev = data.mainEl.eq(0);
    } else {
      mfp.ev = _document;
    }

    if(data.key) {
      if(!mfp.popupsCache[data.key]) {
        mfp.popupsCache[data.key] = {};
      }
      mfp.currTemplate = mfp.popupsCache[data.key];
    } else {
      mfp.currTemplate = {};
    }



    mfp.st = $.extend(true, {}, $.magnificPopup.defaults, data ); 
    mfp.fixedContentPos = mfp.st.fixedContentPos === 'auto' ? !mfp.probablyMobile : mfp.st.fixedContentPos;

    if(mfp.st.modal) {
      mfp.st.closeOnContentClick = false;
      mfp.st.closeOnBgClick = false;
      mfp.st.showCloseBtn = false;
      mfp.st.enableEscapeKey = false;
    }
    

    // Building markup
    // main containers are created only once
    if(!mfp.bgOverlay) {

      // Dark overlay
      mfp.bgOverlay = _getEl('bg').on('click'+EVENT_NS, function() {
        mfp.close();
      });

      mfp.wrap = _getEl('wrap').attr('tabindex', -1).on('click'+EVENT_NS, function(e) {
        if(mfp._checkIfClose(e.target)) {
          mfp.close();
        }
      });

      mfp.container = _getEl('container', mfp.wrap);
    }

    mfp.contentContainer = _getEl('content');
    if(mfp.st.preloader) {
      mfp.preloader = _getEl('preloader', mfp.container, mfp.st.tLoading);
    }


    // Initializing modules
    var modules = $.magnificPopup.modules;
    for(i = 0; i < modules.length; i++) {
      var n = modules[i];
      n = n.charAt(0).toUpperCase() + n.slice(1);
      mfp['init'+n].call(mfp);
    }
    _mfpTrigger('BeforeOpen');


    if(mfp.st.showCloseBtn) {
      // Close button
      if(!mfp.st.closeBtnInside) {
        mfp.wrap.append( _getCloseBtn() );
      } else {
        _mfpOn(MARKUP_PARSE_EVENT, function(e, template, values, item) {
          values.close_replaceWith = _getCloseBtn(item.type);
        });
        _wrapClasses += ' mfp-close-btn-in';
      }
    }

    if(mfp.st.alignTop) {
      _wrapClasses += ' mfp-align-top';
    }

  

    if(mfp.fixedContentPos) {
      mfp.wrap.css({
        overflow: mfp.st.overflowY,
        overflowX: 'hidden',
        overflowY: mfp.st.overflowY
      });
    } else {
      mfp.wrap.css({ 
        top: _window.scrollTop(),
        position: 'absolute'
      });
    }
    if( mfp.st.fixedBgPos === false || (mfp.st.fixedBgPos === 'auto' && !mfp.fixedContentPos) ) {
      mfp.bgOverlay.css({
        height: _document.height(),
        position: 'absolute'
      });
    }

    

    if(mfp.st.enableEscapeKey) {
      // Close on ESC key
      _document.on('keyup' + EVENT_NS, function(e) {
        if(e.keyCode === 27) {
          mfp.close();
        }
      });
    }

    _window.on('resize' + EVENT_NS, function() {
      mfp.updateSize();
    });


    if(!mfp.st.closeOnContentClick) {
      _wrapClasses += ' mfp-auto-cursor';
    }
    
    if(_wrapClasses)
      mfp.wrap.addClass(_wrapClasses);


    // this triggers recalculation of layout, so we get it once to not to trigger twice
    var windowHeight = mfp.wH = _window.height();

    
    var windowStyles = {};

    if( mfp.fixedContentPos ) {
            if(mfp._hasScrollBar(windowHeight)){
                var s = mfp._getScrollbarSize();
                if(s) {
                    windowStyles.marginRight = s;
                }
            }
        }

    if(mfp.fixedContentPos) {
      if(!mfp.isIE7) {
        windowStyles.overflow = 'hidden';
      } else {
        // ie7 double-scroll bug
        $('body, html').css('overflow', 'hidden');
      }
    }

    
    
    var classesToadd = mfp.st.mainClass;
    if(mfp.isIE7) {
      classesToadd += ' mfp-ie7';
    }
    if(classesToadd) {
      mfp._addClassToMFP( classesToadd );
    }

    // add content
    mfp.updateItemHTML();

    _mfpTrigger('BuildControls');

    // remove scrollbar, add margin e.t.c
    $('html').css(windowStyles);
    
    // add everything to DOM
    mfp.bgOverlay.add(mfp.wrap).prependTo( mfp.st.prependTo || $(document.body) );

    // Save last focused element
    mfp._lastFocusedEl = document.activeElement;
    
    // Wait for next cycle to allow CSS transition
    setTimeout(function() {
      
      if(mfp.content) {
        mfp._addClassToMFP(READY_CLASS);
        mfp._setFocus();
      } else {
        // if content is not defined (not loaded e.t.c) we add class only for BG
        mfp.bgOverlay.addClass(READY_CLASS);
      }
      
      // Trap the focus in popup
      _document.on('focusin' + EVENT_NS, mfp._onFocusIn);

    }, 16);

    mfp.isOpen = true;
    mfp.updateSize(windowHeight);
    _mfpTrigger(OPEN_EVENT);

    return data;
  },

  /**
   * Closes the popup
   */
  close: function() {
    if(!mfp.isOpen) return;
    _mfpTrigger(BEFORE_CLOSE_EVENT);

    mfp.isOpen = false;
    // for CSS3 animation
    if(mfp.st.removalDelay && !mfp.isLowIE && mfp.supportsTransition )  {
      mfp._addClassToMFP(REMOVING_CLASS);
      setTimeout(function() {
        mfp._close();
      }, mfp.st.removalDelay);
    } else {
      mfp._close();
    }
  },

  /**
   * Helper for close() function
   */
  _close: function() {
    _mfpTrigger(CLOSE_EVENT);

    var classesToRemove = REMOVING_CLASS + ' ' + READY_CLASS + ' ';

    mfp.bgOverlay.detach();
    mfp.wrap.detach();
    mfp.container.empty();

    if(mfp.st.mainClass) {
      classesToRemove += mfp.st.mainClass + ' ';
    }

    mfp._removeClassFromMFP(classesToRemove);

    if(mfp.fixedContentPos) {
      var windowStyles = {marginRight: ''};
      if(mfp.isIE7) {
        $('body, html').css('overflow', '');
      } else {
        windowStyles.overflow = '';
      }
      $('html').css(windowStyles);
    }
    
    _document.off('keyup' + EVENT_NS + ' focusin' + EVENT_NS);
    mfp.ev.off(EVENT_NS);

    // clean up DOM elements that aren't removed
    mfp.wrap.attr('class', 'mfp-wrap').removeAttr('style');
    mfp.bgOverlay.attr('class', 'mfp-bg');
    mfp.container.attr('class', 'mfp-container');

    // remove close button from target element
    if(mfp.st.showCloseBtn &&
    (!mfp.st.closeBtnInside || mfp.currTemplate[mfp.currItem.type] === true)) {
      if(mfp.currTemplate.closeBtn)
        mfp.currTemplate.closeBtn.detach();
    }


    if(mfp.st.autoFocusLast && mfp._lastFocusedEl) {
      $(mfp._lastFocusedEl).focus(); // put tab focus back
    }
    mfp.currItem = null;  
    mfp.content = null;
    mfp.currTemplate = null;
    mfp.prevHeight = 0;

    _mfpTrigger(AFTER_CLOSE_EVENT);
  },
  
  updateSize: function(winHeight) {

    if(mfp.isIOS) {
      // fixes iOS nav bars https://github.com/dimsemenov/Magnific-Popup/issues/2
      var zoomLevel = document.documentElement.clientWidth / window.innerWidth;
      var height = window.innerHeight * zoomLevel;
      mfp.wrap.css('height', height);
      mfp.wH = height;
    } else {
      mfp.wH = winHeight || _window.height();
    }
    // Fixes #84: popup incorrectly positioned with position:relative on body
    if(!mfp.fixedContentPos) {
      mfp.wrap.css('height', mfp.wH);
    }

    _mfpTrigger('Resize');

  },

  /**
   * Set content of popup based on current index
   */
  updateItemHTML: function() {
    var item = mfp.items[mfp.index];

    // Detach and perform modifications
    mfp.contentContainer.detach();

    if(mfp.content)
      mfp.content.detach();

    if(!item.parsed) {
      item = mfp.parseEl( mfp.index );
    }

    var type = item.type;

    _mfpTrigger('BeforeChange', [mfp.currItem ? mfp.currItem.type : '', type]);
    // BeforeChange event works like so:
    // _mfpOn('BeforeChange', function(e, prevType, newType) { });

    mfp.currItem = item;

    if(!mfp.currTemplate[type]) {
      var markup = mfp.st[type] ? mfp.st[type].markup : false;

      // allows to modify markup
      _mfpTrigger('FirstMarkupParse', markup);

      if(markup) {
        mfp.currTemplate[type] = $(markup);
      } else {
        // if there is no markup found we just define that template is parsed
        mfp.currTemplate[type] = true;
      }
    }

    if(_prevContentType && _prevContentType !== item.type) {
      mfp.container.removeClass('mfp-'+_prevContentType+'-holder');
    }

    var newContent = mfp['get' + type.charAt(0).toUpperCase() + type.slice(1)](item, mfp.currTemplate[type]);
    mfp.appendContent(newContent, type);

    item.preloaded = true;

    _mfpTrigger(CHANGE_EVENT, item);
    _prevContentType = item.type;

    // Append container back after its content changed
    mfp.container.prepend(mfp.contentContainer);

    _mfpTrigger('AfterChange');
  },


  /**
   * Set HTML content of popup
   */
  appendContent: function(newContent, type) {
    mfp.content = newContent;

    if(newContent) {
      if(mfp.st.showCloseBtn && mfp.st.closeBtnInside &&
        mfp.currTemplate[type] === true) {
        // if there is no markup, we just append close button element inside
        if(!mfp.content.find('.mfp-close').length) {
          mfp.content.append(_getCloseBtn());
        }
      } else {
        mfp.content = newContent;
      }
    } else {
      mfp.content = '';
    }

    _mfpTrigger(BEFORE_APPEND_EVENT);
    mfp.container.addClass('mfp-'+type+'-holder');

    mfp.contentContainer.append(mfp.content);
  },


  /**
   * Creates Magnific Popup data object based on given data
   * @param  {int} index Index of item to parse
   */
  parseEl: function(index) {
    var item = mfp.items[index],
      type;

    if(item.tagName) {
      item = { el: $(item) };
    } else {
      type = item.type;
      item = { data: item, src: item.src };
    }

    if(item.el) {
      var types = mfp.types;

      // check for 'mfp-TYPE' class
      for(var i = 0; i < types.length; i++) {
        if( item.el.hasClass('mfp-'+types[i]) ) {
          type = types[i];
          break;
        }
      }

      item.src = item.el.attr('data-mfp-src');
      if(!item.src) {
        item.src = item.el.attr('href');
      }
    }

    item.type = type || mfp.st.type || 'inline';
    item.index = index;
    item.parsed = true;
    mfp.items[index] = item;
    _mfpTrigger('ElementParse', item);

    return mfp.items[index];
  },


  /**
   * Initializes single popup or a group of popups
   */
  addGroup: function(el, options) {
    var eHandler = function(e) {
      e.mfpEl = this;
      mfp._openClick(e, el, options);
    };

    if(!options) {
      options = {};
    }

    var eName = 'click.magnificPopup';
    options.mainEl = el;

    if(options.items) {
      options.isObj = true;
      el.off(eName).on(eName, eHandler);
    } else {
      options.isObj = false;
      if(options.delegate) {
        el.off(eName).on(eName, options.delegate , eHandler);
      } else {
        options.items = el;
        el.off(eName).on(eName, eHandler);
      }
    }
  },
  _openClick: function(e, el, options) {
    var midClick = options.midClick !== undefined ? options.midClick : $.magnificPopup.defaults.midClick;


    if(!midClick && ( e.which === 2 || e.ctrlKey || e.metaKey || e.altKey || e.shiftKey ) ) {
      return;
    }

    var disableOn = options.disableOn !== undefined ? options.disableOn : $.magnificPopup.defaults.disableOn;

    if(disableOn) {
      if($.isFunction(disableOn)) {
        if( !disableOn.call(mfp) ) {
          return true;
        }
      } else { // else it's number
        if( _window.width() < disableOn ) {
          return true;
        }
      }
    }

    if(e.type) {
      e.preventDefault();

      // This will prevent popup from closing if element is inside and popup is already opened
      if(mfp.isOpen) {
        e.stopPropagation();
      }
    }

    options.el = $(e.mfpEl);
    if(options.delegate) {
      options.items = el.find(options.delegate);
    }
    mfp.open(options);
  },


  /**
   * Updates text on preloader
   */
  updateStatus: function(status, text) {

    if(mfp.preloader) {
      if(_prevStatus !== status) {
        mfp.container.removeClass('mfp-s-'+_prevStatus);
      }

      if(!text && status === 'loading') {
        text = mfp.st.tLoading;
      }

      var data = {
        status: status,
        text: text
      };
      // allows to modify status
      _mfpTrigger('UpdateStatus', data);

      status = data.status;
      text = data.text;

      mfp.preloader.html(text);

      mfp.preloader.find('a').on('click', function(e) {
        e.stopImmediatePropagation();
      });

      mfp.container.addClass('mfp-s-'+status);
      _prevStatus = status;
    }
  },


  /*
    "Private" helpers that aren't private at all
   */
  // Check to close popup or not
  // "target" is an element that was clicked
  _checkIfClose: function(target) {

    if($(target).hasClass(PREVENT_CLOSE_CLASS)) {
      return;
    }

    var closeOnContent = mfp.st.closeOnContentClick;
    var closeOnBg = mfp.st.closeOnBgClick;

    if(closeOnContent && closeOnBg) {
      return true;
    } else {

      // We close the popup if click is on close button or on preloader. Or if there is no content.
      if(!mfp.content || $(target).hasClass('mfp-close') || (mfp.preloader && target === mfp.preloader[0]) ) {
        return true;
      }

      // if click is outside the content
      if(  (target !== mfp.content[0] && !$.contains(mfp.content[0], target))  ) {
        if(closeOnBg) {
          // last check, if the clicked element is in DOM, (in case it's removed onclick)
          if( $.contains(document, target) ) {
            return true;
          }
        }
      } else if(closeOnContent) {
        return true;
      }

    }
    return false;
  },
  _addClassToMFP: function(cName) {
    mfp.bgOverlay.addClass(cName);
    mfp.wrap.addClass(cName);
  },
  _removeClassFromMFP: function(cName) {
    this.bgOverlay.removeClass(cName);
    mfp.wrap.removeClass(cName);
  },
  _hasScrollBar: function(winHeight) {
    return (  (mfp.isIE7 ? _document.height() : document.body.scrollHeight) > (winHeight || _window.height()) );
  },
  _setFocus: function() {
    (mfp.st.focus ? mfp.content.find(mfp.st.focus).eq(0) : mfp.wrap).focus();
  },
  _onFocusIn: function(e) {
    if( e.target !== mfp.wrap[0] && !$.contains(mfp.wrap[0], e.target) ) {
      mfp._setFocus();
      return false;
    }
  },
  _parseMarkup: function(template, values, item) {
    var arr;
    if(item.data) {
      values = $.extend(item.data, values);
    }
    _mfpTrigger(MARKUP_PARSE_EVENT, [template, values, item] );

    $.each(values, function(key, value) {
      if(value === undefined || value === false) {
        return true;
      }
      arr = key.split('_');
      if(arr.length > 1) {
        var el = template.find(EVENT_NS + '-'+arr[0]);

        if(el.length > 0) {
          var attr = arr[1];
          if(attr === 'replaceWith') {
            if(el[0] !== value[0]) {
              el.replaceWith(value);
            }
          } else if(attr === 'img') {
            if(el.is('img')) {
              el.attr('src', value);
            } else {
              el.replaceWith( $('<img>').attr('src', value).attr('class', el.attr('class')) );
            }
          } else {
            el.attr(arr[1], value);
          }
        }

      } else {
        template.find(EVENT_NS + '-'+key).html(value);
      }
    });
  },

  _getScrollbarSize: function() {
    // thx David
    if(mfp.scrollbarSize === undefined) {
      var scrollDiv = document.createElement("div");
      scrollDiv.style.cssText = 'width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;';
      document.body.appendChild(scrollDiv);
      mfp.scrollbarSize = scrollDiv.offsetWidth - scrollDiv.clientWidth;
      document.body.removeChild(scrollDiv);
    }
    return mfp.scrollbarSize;
  }

}; /* MagnificPopup core prototype end */




/**
 * Public static functions
 */
$.magnificPopup = {
  instance: null,
  proto: MagnificPopup.prototype,
  modules: [],

  open: function(options, index) {
    _checkInstance();

    if(!options) {
      options = {};
    } else {
      options = $.extend(true, {}, options);
    }

    options.isObj = true;
    options.index = index || 0;
    return this.instance.open(options);
  },

  close: function() {
    return $.magnificPopup.instance && $.magnificPopup.instance.close();
  },

  registerModule: function(name, module) {
    if(module.options) {
      $.magnificPopup.defaults[name] = module.options;
    }
    $.extend(this.proto, module.proto);
    this.modules.push(name);
  },

  defaults: {

    // Info about options is in docs:
    // http://dimsemenov.com/plugins/magnific-popup/documentation.html#options

    disableOn: 0,

    key: null,

    midClick: false,

    mainClass: '',

    preloader: true,

    focus: '', // CSS selector of input to focus after popup is opened

    closeOnContentClick: false,

    closeOnBgClick: true,

    closeBtnInside: true,

    showCloseBtn: true,

    enableEscapeKey: true,

    modal: false,

    alignTop: false,

    removalDelay: 0,

    prependTo: null,

    fixedContentPos: 'auto',

    fixedBgPos: 'auto',

    overflowY: 'auto',

    closeMarkup: '<button title="%title%" type="button" class="mfp-close">&#215;</button>',

    tClose: 'Close (Esc)',

    tLoading: 'Loading...',

    autoFocusLast: true

  }
};



$.fn.magnificPopup = function(options) {
  _checkInstance();

  var jqEl = $(this);

  // We call some API method of first param is a string
  if (typeof options === "string" ) {

    if(options === 'open') {
      var items,
        itemOpts = _isJQ ? jqEl.data('magnificPopup') : jqEl[0].magnificPopup,
        index = parseInt(arguments[1], 10) || 0;

      if(itemOpts.items) {
        items = itemOpts.items[index];
      } else {
        items = jqEl;
        if(itemOpts.delegate) {
          items = items.find(itemOpts.delegate);
        }
        items = items.eq( index );
      }
      mfp._openClick({mfpEl:items}, jqEl, itemOpts);
    } else {
      if(mfp.isOpen)
        mfp[options].apply(mfp, Array.prototype.slice.call(arguments, 1));
    }

  } else {
    // clone options obj
    options = $.extend(true, {}, options);

    /*
     * As Zepto doesn't support .data() method for objects
     * and it works only in normal browsers
     * we assign "options" object directly to the DOM element. FTW!
     */
    if(_isJQ) {
      jqEl.data('magnificPopup', options);
    } else {
      jqEl[0].magnificPopup = options;
    }

    mfp.addGroup(jqEl, options);

  }
  return jqEl;
};

/*>>core*/

/*>>inline*/

var INLINE_NS = 'inline',
  _hiddenClass,
  _inlinePlaceholder,
  _lastInlineElement,
  _putInlineElementsBack = function() {
    if(_lastInlineElement) {
      _inlinePlaceholder.after( _lastInlineElement.addClass(_hiddenClass) ).detach();
      _lastInlineElement = null;
    }
  };

$.magnificPopup.registerModule(INLINE_NS, {
  options: {
    hiddenClass: 'hide', // will be appended with `mfp-` prefix
    markup: '',
    tNotFound: 'Content not found'
  },
  proto: {

    initInline: function() {
      mfp.types.push(INLINE_NS);

      _mfpOn(CLOSE_EVENT+'.'+INLINE_NS, function() {
        _putInlineElementsBack();
      });
    },

    getInline: function(item, template) {

      _putInlineElementsBack();

      if(item.src) {
        var inlineSt = mfp.st.inline,
          el = $(item.src);

        if(el.length) {

          // If target element has parent - we replace it with placeholder and put it back after popup is closed
          var parent = el[0].parentNode;
          if(parent && parent.tagName) {
            if(!_inlinePlaceholder) {
              _hiddenClass = inlineSt.hiddenClass;
              _inlinePlaceholder = _getEl(_hiddenClass);
              _hiddenClass = 'mfp-'+_hiddenClass;
            }
            // replace target inline element with placeholder
            _lastInlineElement = el.after(_inlinePlaceholder).detach().removeClass(_hiddenClass);
          }

          mfp.updateStatus('ready');
        } else {
          mfp.updateStatus('error', inlineSt.tNotFound);
          el = $('<div>');
        }

        item.inlineElement = el;
        return el;
      }

      mfp.updateStatus('ready');
      mfp._parseMarkup(template, {}, item);
      return template;
    }
  }
});

/*>>inline*/

/*>>ajax*/
var AJAX_NS = 'ajax',
  _ajaxCur,
  _removeAjaxCursor = function() {
    if(_ajaxCur) {
      $(document.body).removeClass(_ajaxCur);
    }
  },
  _destroyAjaxRequest = function() {
    _removeAjaxCursor();
    if(mfp.req) {
      mfp.req.abort();
    }
  };

$.magnificPopup.registerModule(AJAX_NS, {

  options: {
    settings: null,
    cursor: 'mfp-ajax-cur',
    tError: '<a href="%url%">The content</a> could not be loaded.'
  },

  proto: {
    initAjax: function() {
      mfp.types.push(AJAX_NS);
      _ajaxCur = mfp.st.ajax.cursor;

      _mfpOn(CLOSE_EVENT+'.'+AJAX_NS, _destroyAjaxRequest);
      _mfpOn('BeforeChange.' + AJAX_NS, _destroyAjaxRequest);
    },
    getAjax: function(item) {

      if(_ajaxCur) {
        $(document.body).addClass(_ajaxCur);
      }

      mfp.updateStatus('loading');

      var opts = $.extend({
        url: item.src,
        success: function(data, textStatus, jqXHR) {
          var temp = {
            data:data,
            xhr:jqXHR
          };

          _mfpTrigger('ParseAjax', temp);

          mfp.appendContent( $(temp.data), AJAX_NS );

          item.finished = true;

          _removeAjaxCursor();

          mfp._setFocus();

          setTimeout(function() {
            mfp.wrap.addClass(READY_CLASS);
          }, 16);

          mfp.updateStatus('ready');

          _mfpTrigger('AjaxContentAdded');
        },
        error: function() {
          _removeAjaxCursor();
          item.finished = item.loadError = true;
          mfp.updateStatus('error', mfp.st.ajax.tError.replace('%url%', item.src));
        }
      }, mfp.st.ajax.settings);

      mfp.req = $.ajax(opts);

      return '';
    }
  }
});

/*>>ajax*/

/*>>image*/
var _imgInterval,
  _getTitle = function(item) {
    if(item.data && item.data.title !== undefined)
      return item.data.title;

    var src = mfp.st.image.titleSrc;

    if(src) {
      if($.isFunction(src)) {
        return src.call(mfp, item);
      } else if(item.el) {
        return item.el.attr(src) || '';
      }
    }
    return '';
  };

$.magnificPopup.registerModule('image', {

  options: {
    markup: '<div class="mfp-figure">'+
          '<div class="mfp-close"></div>'+
          '<figure>'+
            '<div class="mfp-img"></div>'+
            '<figcaption>'+
              '<div class="mfp-bottom-bar">'+
                '<div class="mfp-title"></div>'+
                '<div class="mfp-counter"></div>'+
              '</div>'+
            '</figcaption>'+
          '</figure>'+
        '</div>',
    cursor: 'mfp-zoom-out-cur',
    titleSrc: 'title',
    verticalFit: true,
    tError: '<a href="%url%">The image</a> could not be loaded.'
  },

  proto: {
    initImage: function() {
      var imgSt = mfp.st.image,
        ns = '.image';

      mfp.types.push('image');

      _mfpOn(OPEN_EVENT+ns, function() {
        if(mfp.currItem.type === 'image' && imgSt.cursor) {
          $(document.body).addClass(imgSt.cursor);
        }
      });

      _mfpOn(CLOSE_EVENT+ns, function() {
        if(imgSt.cursor) {
          $(document.body).removeClass(imgSt.cursor);
        }
        _window.off('resize' + EVENT_NS);
      });

      _mfpOn('Resize'+ns, mfp.resizeImage);
      if(mfp.isLowIE) {
        _mfpOn('AfterChange', mfp.resizeImage);
      }
    },
    resizeImage: function() {
      var item = mfp.currItem;
      if(!item || !item.img) return;

      if(mfp.st.image.verticalFit) {
        var decr = 0;
        // fix box-sizing in ie7/8
        if(mfp.isLowIE) {
          decr = parseInt(item.img.css('padding-top'), 10) + parseInt(item.img.css('padding-bottom'),10);
        }
        item.img.css('max-height', mfp.wH-decr);
      }
    },
    _onImageHasSize: function(item) {
      if(item.img) {

        item.hasSize = true;

        if(_imgInterval) {
          clearInterval(_imgInterval);
        }

        item.isCheckingImgSize = false;

        _mfpTrigger('ImageHasSize', item);

        if(item.imgHidden) {
          if(mfp.content)
            mfp.content.removeClass('mfp-loading');

          item.imgHidden = false;
        }

      }
    },

    /**
     * Function that loops until the image has size to display elements that rely on it asap
     */
    findImageSize: function(item) {

      var counter = 0,
        img = item.img[0],
        mfpSetInterval = function(delay) {

          if(_imgInterval) {
            clearInterval(_imgInterval);
          }
          // decelerating interval that checks for size of an image
          _imgInterval = setInterval(function() {
            if(img.naturalWidth > 0) {
              mfp._onImageHasSize(item);
              return;
            }

            if(counter > 200) {
              clearInterval(_imgInterval);
            }

            counter++;
            if(counter === 3) {
              mfpSetInterval(10);
            } else if(counter === 40) {
              mfpSetInterval(50);
            } else if(counter === 100) {
              mfpSetInterval(500);
            }
          }, delay);
        };

      mfpSetInterval(1);
    },

    getImage: function(item, template) {

      var guard = 0,

        // image load complete handler
        onLoadComplete = function() {
          if(item) {
            if (item.img[0].complete) {
              item.img.off('.mfploader');

              if(item === mfp.currItem){
                mfp._onImageHasSize(item);

                mfp.updateStatus('ready');
              }

              item.hasSize = true;
              item.loaded = true;

              _mfpTrigger('ImageLoadComplete');

            }
            else {
              // if image complete check fails 200 times (20 sec), we assume that there was an error.
              guard++;
              if(guard < 200) {
                setTimeout(onLoadComplete,100);
              } else {
                onLoadError();
              }
            }
          }
        },

        // image error handler
        onLoadError = function() {
          if(item) {
            item.img.off('.mfploader');
            if(item === mfp.currItem){
              mfp._onImageHasSize(item);
              mfp.updateStatus('error', imgSt.tError.replace('%url%', item.src) );
            }

            item.hasSize = true;
            item.loaded = true;
            item.loadError = true;
          }
        },
        imgSt = mfp.st.image;


      var el = template.find('.mfp-img');
      if(el.length) {
        var img = document.createElement('img');
        img.className = 'mfp-img';
        if(item.el && item.el.find('img').length) {
          img.alt = item.el.find('img').attr('alt');
        }
        item.img = $(img).on('load.mfploader', onLoadComplete).on('error.mfploader', onLoadError);
        img.src = item.src;

        // without clone() "error" event is not firing when IMG is replaced by new IMG
        // TODO: find a way to avoid such cloning
        if(el.is('img')) {
          item.img = item.img.clone();
        }

        img = item.img[0];
        if(img.naturalWidth > 0) {
          item.hasSize = true;
        } else if(!img.width) {
          item.hasSize = false;
        }
      }

      mfp._parseMarkup(template, {
        title: _getTitle(item),
        img_replaceWith: item.img
      }, item);

      mfp.resizeImage();

      if(item.hasSize) {
        if(_imgInterval) clearInterval(_imgInterval);

        if(item.loadError) {
          template.addClass('mfp-loading');
          mfp.updateStatus('error', imgSt.tError.replace('%url%', item.src) );
        } else {
          template.removeClass('mfp-loading');
          mfp.updateStatus('ready');
        }
        return template;
      }

      mfp.updateStatus('loading');
      item.loading = true;

      if(!item.hasSize) {
        item.imgHidden = true;
        template.addClass('mfp-loading');
        mfp.findImageSize(item);
      }

      return template;
    }
  }
});

/*>>image*/

/*>>zoom*/
var hasMozTransform,
  getHasMozTransform = function() {
    if(hasMozTransform === undefined) {
      hasMozTransform = document.createElement('p').style.MozTransform !== undefined;
    }
    return hasMozTransform;
  };

$.magnificPopup.registerModule('zoom', {

  options: {
    enabled: false,
    easing: 'ease-in-out',
    duration: 300,
    opener: function(element) {
      return element.is('img') ? element : element.find('img');
    }
  },

  proto: {

    initZoom: function() {
      var zoomSt = mfp.st.zoom,
        ns = '.zoom',
        image;

      if(!zoomSt.enabled || !mfp.supportsTransition) {
        return;
      }

      var duration = zoomSt.duration,
        getElToAnimate = function(image) {
          var newImg = image.clone().removeAttr('style').removeAttr('class').addClass('mfp-animated-image'),
            transition = 'all '+(zoomSt.duration/1000)+'s ' + zoomSt.easing,
            cssObj = {
              position: 'fixed',
              zIndex: 9999,
              left: 0,
              top: 0,
              '-webkit-backface-visibility': 'hidden'
            },
            t = 'transition';

          cssObj['-webkit-'+t] = cssObj['-moz-'+t] = cssObj['-o-'+t] = cssObj[t] = transition;

          newImg.css(cssObj);
          return newImg;
        },
        showMainContent = function() {
          mfp.content.css('visibility', 'visible');
        },
        openTimeout,
        animatedImg;

      _mfpOn('BuildControls'+ns, function() {
        if(mfp._allowZoom()) {

          clearTimeout(openTimeout);
          mfp.content.css('visibility', 'hidden');

          // Basically, all code below does is clones existing image, puts in on top of the current one and animated it

          image = mfp._getItemToZoom();

          if(!image) {
            showMainContent();
            return;
          }

          animatedImg = getElToAnimate(image);

          animatedImg.css( mfp._getOffset() );

          mfp.wrap.append(animatedImg);

          openTimeout = setTimeout(function() {
            animatedImg.css( mfp._getOffset( true ) );
            openTimeout = setTimeout(function() {

              showMainContent();

              setTimeout(function() {
                animatedImg.remove();
                image = animatedImg = null;
                _mfpTrigger('ZoomAnimationEnded');
              }, 16); // avoid blink when switching images

            }, duration); // this timeout equals animation duration

          }, 16); // by adding this timeout we avoid short glitch at the beginning of animation


          // Lots of timeouts...
        }
      });
      _mfpOn(BEFORE_CLOSE_EVENT+ns, function() {
        if(mfp._allowZoom()) {

          clearTimeout(openTimeout);

          mfp.st.removalDelay = duration;

          if(!image) {
            image = mfp._getItemToZoom();
            if(!image) {
              return;
            }
            animatedImg = getElToAnimate(image);
          }

          animatedImg.css( mfp._getOffset(true) );
          mfp.wrap.append(animatedImg);
          mfp.content.css('visibility', 'hidden');

          setTimeout(function() {
            animatedImg.css( mfp._getOffset() );
          }, 16);
        }

      });

      _mfpOn(CLOSE_EVENT+ns, function() {
        if(mfp._allowZoom()) {
          showMainContent();
          if(animatedImg) {
            animatedImg.remove();
          }
          image = null;
        }
      });
    },

    _allowZoom: function() {
      return mfp.currItem.type === 'image';
    },

    _getItemToZoom: function() {
      if(mfp.currItem.hasSize) {
        return mfp.currItem.img;
      } else {
        return false;
      }
    },

    // Get element postion relative to viewport
    _getOffset: function(isLarge) {
      var el;
      if(isLarge) {
        el = mfp.currItem.img;
      } else {
        el = mfp.st.zoom.opener(mfp.currItem.el || mfp.currItem);
      }

      var offset = el.offset();
      var paddingTop = parseInt(el.css('padding-top'),10);
      var paddingBottom = parseInt(el.css('padding-bottom'),10);
      offset.top -= ( $(window).scrollTop() - paddingTop );


      /*

      Animating left + top + width/height looks glitchy in Firefox, but perfect in Chrome. And vice-versa.

       */
      var obj = {
        width: el.width(),
        // fix Zepto height+padding issue
        height: (_isJQ ? el.innerHeight() : el[0].offsetHeight) - paddingBottom - paddingTop
      };

      // I hate to do this, but there is no another option
      if( getHasMozTransform() ) {
        obj['-moz-transform'] = obj['transform'] = 'translate(' + offset.left + 'px,' + offset.top + 'px)';
      } else {
        obj.left = offset.left;
        obj.top = offset.top;
      }
      return obj;
    }

  }
});



/*>>zoom*/

/*>>iframe*/

var IFRAME_NS = 'iframe',
  _emptyPage = '//about:blank',

  _fixIframeBugs = function(isShowing) {
    if(mfp.currTemplate[IFRAME_NS]) {
      var el = mfp.currTemplate[IFRAME_NS].find('iframe');
      if(el.length) {
        // reset src after the popup is closed to avoid "video keeps playing after popup is closed" bug
        if(!isShowing) {
          el[0].src = _emptyPage;
        }

        // IE8 black screen bug fix
        if(mfp.isIE8) {
          el.css('display', isShowing ? 'block' : 'none');
        }
      }
    }
  };

$.magnificPopup.registerModule(IFRAME_NS, {

  options: {
    markup: '<div class="mfp-iframe-scaler">'+
          '<div class="mfp-close"></div>'+
          '<iframe class="mfp-iframe" src="//about:blank" frameborder="0" allowfullscreen></iframe>'+
        '</div>',

    srcAction: 'iframe_src',

    // we don't care and support only one default type of URL by default
    patterns: {
      youtube: {
        index: 'youtube.com',
        id: 'v=',
        src: 'https://www.youtube.com/embed/%id%?autoplay=1'
      },
      vimeo: {
        index: 'vimeo.com/',
        id: '/',
        src: 'https://player.vimeo.com/video/%id%?autoplay=1'
      },
      gmaps: {
        index: '//maps.google.',
        src: '%id%&output=embed'
      }
    }
  },

  proto: {
    initIframe: function() {
      mfp.types.push(IFRAME_NS);

      _mfpOn('BeforeChange', function(e, prevType, newType) {
        if(prevType !== newType) {
          if(prevType === IFRAME_NS) {
            _fixIframeBugs(); // iframe if removed
          } else if(newType === IFRAME_NS) {
            _fixIframeBugs(true); // iframe is showing
          }
        }// else {
          // iframe source is switched, don't do anything
        //}
      });

      _mfpOn(CLOSE_EVENT + '.' + IFRAME_NS, function() {
        _fixIframeBugs();
      });
    },

    getIframe: function(item, template) {
      var embedSrc = item.src;
      var iframeSt = mfp.st.iframe;

      $.each(iframeSt.patterns, function() {
        if(embedSrc.indexOf( this.index ) > -1) {
          if(this.id) {
            if(typeof this.id === 'string') {
              embedSrc = embedSrc.substr(embedSrc.lastIndexOf(this.id)+this.id.length, embedSrc.length);
            } else {
              embedSrc = this.id.call( this, embedSrc );
            }
          }
          embedSrc = this.src.replace('%id%', embedSrc );
          return false; // break;
        }
      });

      var dataObj = {};
      if(iframeSt.srcAction) {
        dataObj[iframeSt.srcAction] = embedSrc;
      }
      mfp._parseMarkup(template, dataObj, item);

      mfp.updateStatus('ready');

      return template;
    }
  }
});



/*>>iframe*/

/*>>gallery*/
/**
 * Get looped index depending on number of slides
 */
var _getLoopedId = function(index) {
    var numSlides = mfp.items.length;
    if(index > numSlides - 1) {
      return index - numSlides;
    } else  if(index < 0) {
      return numSlides + index;
    }
    return index;
  },
  _replaceCurrTotal = function(text, curr, total) {
    return text.replace(/%curr%/gi, curr + 1).replace(/%total%/gi, total);
  };

$.magnificPopup.registerModule('gallery', {

  options: {
    enabled: false,
    arrowMarkup: '<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"></button>',
    preload: [0,2],
    navigateByImgClick: true,
    arrows: true,

    tPrev: 'Previous (Left arrow key)',
    tNext: 'Next (Right arrow key)',
    tCounter: '%curr% of %total%'
  },

  proto: {
    initGallery: function() {

      var gSt = mfp.st.gallery,
        ns = '.mfp-gallery';

      mfp.direction = true; // true - next, false - prev

      if(!gSt || !gSt.enabled ) return false;

      _wrapClasses += ' mfp-gallery';

      _mfpOn(OPEN_EVENT+ns, function() {

        if(gSt.navigateByImgClick) {
          mfp.wrap.on('click'+ns, '.mfp-img', function() {
            if(mfp.items.length > 1) {
              mfp.next();
              return false;
            }
          });
        }

        _document.on('keydown'+ns, function(e) {
          if (e.keyCode === 37) {
            mfp.prev();
          } else if (e.keyCode === 39) {
            mfp.next();
          }
        });
      });

      _mfpOn('UpdateStatus'+ns, function(e, data) {
        if(data.text) {
          data.text = _replaceCurrTotal(data.text, mfp.currItem.index, mfp.items.length);
        }
      });

      _mfpOn(MARKUP_PARSE_EVENT+ns, function(e, element, values, item) {
        var l = mfp.items.length;
        values.counter = l > 1 ? _replaceCurrTotal(gSt.tCounter, item.index, l) : '';
      });

      _mfpOn('BuildControls' + ns, function() {
        if(mfp.items.length > 1 && gSt.arrows && !mfp.arrowLeft) {
          var markup = gSt.arrowMarkup,
            arrowLeft = mfp.arrowLeft = $( markup.replace(/%title%/gi, gSt.tPrev).replace(/%dir%/gi, 'left') ).addClass(PREVENT_CLOSE_CLASS),
            arrowRight = mfp.arrowRight = $( markup.replace(/%title%/gi, gSt.tNext).replace(/%dir%/gi, 'right') ).addClass(PREVENT_CLOSE_CLASS);

          arrowLeft.click(function() {
            mfp.prev();
          });
          arrowRight.click(function() {
            mfp.next();
          });

          mfp.container.append(arrowLeft.add(arrowRight));
        }
      });

      _mfpOn(CHANGE_EVENT+ns, function() {
        if(mfp._preloadTimeout) clearTimeout(mfp._preloadTimeout);

        mfp._preloadTimeout = setTimeout(function() {
          mfp.preloadNearbyImages();
          mfp._preloadTimeout = null;
        }, 16);
      });


      _mfpOn(CLOSE_EVENT+ns, function() {
        _document.off(ns);
        mfp.wrap.off('click'+ns);
        mfp.arrowRight = mfp.arrowLeft = null;
      });

    },
    next: function() {
      mfp.direction = true;
      mfp.index = _getLoopedId(mfp.index + 1);
      mfp.updateItemHTML();
    },
    prev: function() {
      mfp.direction = false;
      mfp.index = _getLoopedId(mfp.index - 1);
      mfp.updateItemHTML();
    },
    goTo: function(newIndex) {
      mfp.direction = (newIndex >= mfp.index);
      mfp.index = newIndex;
      mfp.updateItemHTML();
    },
    preloadNearbyImages: function() {
      var p = mfp.st.gallery.preload,
        preloadBefore = Math.min(p[0], mfp.items.length),
        preloadAfter = Math.min(p[1], mfp.items.length),
        i;

      for(i = 1; i <= (mfp.direction ? preloadAfter : preloadBefore); i++) {
        mfp._preloadItem(mfp.index+i);
      }
      for(i = 1; i <= (mfp.direction ? preloadBefore : preloadAfter); i++) {
        mfp._preloadItem(mfp.index-i);
      }
    },
    _preloadItem: function(index) {
      index = _getLoopedId(index);

      if(mfp.items[index].preloaded) {
        return;
      }

      var item = mfp.items[index];
      if(!item.parsed) {
        item = mfp.parseEl( index );
      }

      _mfpTrigger('LazyLoad', item);

      if(item.type === 'image') {
        item.img = $('<img class="mfp-img" />').on('load.mfploader', function() {
          item.hasSize = true;
        }).on('error.mfploader', function() {
          item.hasSize = true;
          item.loadError = true;
          _mfpTrigger('LazyLoadError', item);
        }).attr('src', item.src);
      }


      item.preloaded = true;
    }
  }
});

/*>>gallery*/

/*>>retina*/

var RETINA_NS = 'retina';

$.magnificPopup.registerModule(RETINA_NS, {
  options: {
    replaceSrc: function(item) {
      return item.src.replace(/\.\w+$/, function(m) { return '@2x' + m; });
    },
    ratio: 1 // Function or number.  Set to 1 to disable.
  },
  proto: {
    initRetina: function() {
      if(window.devicePixelRatio > 1) {

        var st = mfp.st.retina,
          ratio = st.ratio;

        ratio = !isNaN(ratio) ? ratio : ratio();

        if(ratio > 1) {
          _mfpOn('ImageHasSize' + '.' + RETINA_NS, function(e, item) {
            item.img.css({
              'max-width': item.img[0].naturalWidth / ratio,
              'width': '100%'
            });
          });
          _mfpOn('ElementParse' + '.' + RETINA_NS, function(e, item) {
            item.src = st.replaceSrc(item, ratio);
          });
        }
      }

    }
  }
});

/*>>retina*/
 _checkInstance(); }));








/*-------------------------------------------------------------
  06. CounterUp jquery menu plugin
---------------------------------------------------------------*/
/*!
* jquery.counterup.js 1.0
*
* Copyright 2013, Benjamin Intal http://gambit.ph @bfintal
* Released under the GPL v2 License
*
* Date: Nov 26, 2013
*/(function(e){"use strict";e.fn.counterUp=function(t){var n=e.extend({time:400,delay:10},t);return this.each(function(){var t=e(this),r=n,i=function(){var e=[],n=r.time/r.delay,i=t.text(),s=/[0-9]+,[0-9]+/.test(i);i=i.replace(/,/g,"");var o=/^[0-9]+$/.test(i),u=/^[0-9]+\.[0-9]+$/.test(i),a=u?(i.split(".")[1]||[]).length:0;for(var f=n;f>=1;f--){var l=parseInt(i/n*f);u&&(l=parseFloat(i/n*f).toFixed(a));if(s)while(/(\d+)(\d{3})/.test(l.toString()))l=l.toString().replace(/(\d+)(\d{3})/,"$1,$2");e.unshift(l)}t.data("counterup-nums",e);t.text("0");var c=function(){t.text(t.data("counterup-nums").shift());if(t.data("counterup-nums").length)setTimeout(t.data("counterup-func"),r.delay);else{delete t.data("counterup-nums");t.data("counterup-nums",null);t.data("counterup-func",null)}};t.data("counterup-func",c);setTimeout(t.data("counterup-func"),r.delay)};t.waypoint(i,{offset:"100%",triggerOnce:!0})})}})(jQuery);










